/**
 * 
 */
package com.xunlei.channel.db.pojo;

import static com.xunlei.channel.db.common.Constants.SEND_NOTICE_STATUS_OK;

import java.util.Date;

import com.xunlei.channel.db.common.Constants;

/**
 * 成功订单表
 * 
 * @author gonglijian
 */
public class PayOrderOk extends AbstractOrder {

    /**
	 * 
	 */
    private static final long serialVersionUID = 7268306584621948873L;

    /**
     * 给商户发送支付通知
     */
    private String            sendNoticeStatus = Constants.SEND_NOTICE_STATUS_FAIL;
    /**
     * 第三方分走的佣金(分)
     */
    private Integer           fareAmt;
    /**
     * 订单净收入：orderAmt-fareAmt
     */
    private Integer           factAmt;
    /**
     * 下订单的时间,等于payOrder的createTime
     */
    private Date              reqTime;

    /**
     * 订单成功的日期，yyyy-MM-dd
     */
    private String            balanceDate;

    /**
     * @return the sendNoticeStatus
     */
    public String getSendNoticeStatus() {
        return sendNoticeStatus;
    }

    /**
     * @param sendNoticeStatus the sendNoticeStatus to set
     */
    public void setSendNoticeStatus(String sendNoticeStatus) {
        this.sendNoticeStatus = sendNoticeStatus;
    }

    /**
     * @return the fareAmt
     */
    public Integer getFareAmt() {
        return fareAmt;
    }

    /**
     * @param fareAmt the fareAmt to set
     */
    public void setFareAmt(Integer fareAmt) {
        this.fareAmt = fareAmt;
    }

    /**
     * @return the factAmt
     */
    public Integer getFactAmt() {
        return factAmt;
    }

    /**
     * @param factAmt the factAmt to set
     */
    public void setFactAmt(Integer factAmt) {
        this.factAmt = factAmt;
    }

    /**
     * @return the reqTime
     */
    public Date getReqTime() {
        return reqTime;
    }

    /**
     * @param reqTime the reqTime to set
     */
    public void setReqTime(Date reqTime) {
        this.reqTime = reqTime;
    }

    public String getBalanceDate() {return balanceDate;}

    public void setBalanceDate(String balanceDate) {this.balanceDate = balanceDate;}

    /**
     * 判断是否已经发送了支付通知
     * 
     * @param sendNoticeStatus
     * @return
     */
    public static boolean isNoticeSended(String sendNoticeStatus) {
        return SEND_NOTICE_STATUS_OK.equals(sendNoticeStatus);
    }

}
