/**
 * Project: dbservice
 * 
 * File Created at 2014年12月11日
 * gonglijian
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.pojo;

import java.util.Date;

/**
 * 支付通知表，状态值区分成功或者失败，noticeTime表示最后一次通知时间
 * 
 * @author gonglijian
 */
public class PayNotice extends AbstractBaseEntity {
    /**
	 * 
	 */
    private static final long serialVersionUID = 4315109265197728151L;
    /**
     * 迅雷支付号
     */
    private String            xunleiPayId;
    /**
     * 失败次数
     */
    private Integer           failTimes;
    /**
     * 上次通知时间
     */
    private Date              noticeTime;
    /**
     * S成功，F失败
     */
    private String            status;
    /**
     * 上次失败的错误信息
     */
    private String            errorMsg;
    /**
     * 分片日期，yyyy-MM-dd
     */
    private String            ruleDate;

    /**
     * @return the xunleiPayId
     */
    public String getXunleiPayId() {
        return xunleiPayId;
    }

    /**
     * @param xunleiPayId the xunleiPayId to set
     */
    public void setXunleiPayId(String xunleiPayId) {
        this.xunleiPayId = xunleiPayId;
    }

    /**
     * @return the failTimes
     */
    public Integer getFailTimes() {
        return failTimes;
    }

    /**
     * @param failTimes the failTimes to set
     */
    public void setFailTimes(Integer failTimes) {
        this.failTimes = failTimes;
    }

    /**
     * @return the noticeTime
     */
    public Date getNoticeTime() {
        return noticeTime;
    }

    /**
     * @param noticeTime the noticeTime to set
     */
    public void setNoticeTime(Date noticeTime) {
        this.noticeTime = noticeTime;
    }

    /**
     * @return the status
     */
    public String getStatus() {
        return status;
    }

    /**
     * @param status the status to set
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * @return the errorMsg
     */
    public String getErrorMsg() {
        return errorMsg;
    }

    /**
     * @param errorMsg the errorMsg to set
     */
    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getRuleDate() {return ruleDate;}

    public void setRuleDate(String ruleDate) {this.ruleDate = ruleDate;}
}
