package com.xunlei.channel.db.pojo;

/**
 * 抽象出请求订单和成功订单共有的属性
 * 
 * @author gonglijian
 */
public abstract class AbstractOrder extends AbstractBaseEntity {

    /**
     * 
     */
    private static final long serialVersionUID = -3544307369029182775L;

    /**
     * 这是迅雷支付系统内唯一标识一条支付信息记录
     */
    private String            xunleiPayId;

    private String            version;

    /**
     * A：UTF-8 B：GBK
     */
    private String            pageCharset;

    /**
     * 商户后台接收迅雷支付通知的地址
     */
    private String            notifyUrl;

    /**
     * 商户前台接收迅雷支付通知的地址
     */
    private String            pageUrl;

    /**
     * 迅雷支付配置的业务号
     */
    private String            bizNo;

    /**
     * 业务方唯一订单号
     */
    private String            bizOrderId;

    /**
     * 支付网关的各渠道编码
     */
    private String            payType;

    /**
     * 以分为单位
     */
    private int               orderAmt;

    /**
     * 订单组别
     */
    private String            orderGroup;

    /**
     * 渠道订单号
     */
    private String            channelOrderId;

    /**
     * 内部ID
     */
    private String            xunleiId;

    /**
     * 支付订单的迅雷账号
     */
    private String            userShow;

    /**
     * 商品ID
     */
    private long              productId;

    /**
     * 商品名称
     */
    private String            productName;

    /**
     * 商品描述
     */
    private String            productDesc;

    /**
     * 用户手机号
     */
    private String            phone;

    /**
     * 扩展信息,商户提交过来的数据，通知的时候要原封不动的带过去
     */
    private String            bizExt;

    /**
     * 用户IP
     */
    private String            orderIp;

    /**
     * JSON格式
     */
    private String            extraJson;

    /**
     * A：支付订单；B：包月订单；C：自动续费订单；D：退款订单；E：批量付款
     */
    private String            orderType;

    /**
     * 订单来源，用这个维度来统计订单，比如白金会员来自手雷的
     */
    private String            peerId;

    /**
     * 分片日期，yyyy-MM-dd
     */
    private String            ruleDate;

    /**
     * @return the peerId
     */
    public String getPeerId() {
        return peerId;
    }

    /**
     * @param peerId the peerId to set
     */
    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    /**
     * @return the version
     */
    public String getVersion() {
        return version;
    }

    /**
     * @param version the version to set
     */
    public void setVersion(String version) {
        this.version = version;
    }

    public String getXunleiPayId() {
        return xunleiPayId;
    }

    public void setXunleiPayId(String xunleiPayId) {
        this.xunleiPayId = xunleiPayId;
    }

    public String getPageCharset() {
        return pageCharset;
    }

    public void setPageCharset(String pageCharset) {
        this.pageCharset = pageCharset;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getPageUrl() {
        return pageUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public String getBizNo() {
        return bizNo;
    }

    public void setBizNo(String bizNo) {
        this.bizNo = bizNo;
    }

    public String getBizOrderId() {
        return bizOrderId;
    }

    public void setBizOrderId(String bizOrderId) {
        this.bizOrderId = bizOrderId;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public int getOrderAmt() {
        return orderAmt;
    }

    public void setOrderAmt(int orderAmt) {
        this.orderAmt = orderAmt;
    }

    public String getOrderGroup() {
        return orderGroup;
    }

    public void setOrderGroup(String orderGroup) {
        this.orderGroup = orderGroup;
    }

    public String getChannelOrderId() {
        return channelOrderId;
    }

    public void setChannelOrderId(String channelOrderId) {
        this.channelOrderId = channelOrderId;
    }

    public String getXunleiId() {
        return xunleiId;
    }

    public void setXunleiId(String xunleiId) {
        this.xunleiId = xunleiId;
    }

    public String getUserShow() {
        return userShow;
    }

    public void setUserShow(String userShow) {
        this.userShow = userShow;
    }

    /**
     * @return the productId
     */
    public long getProductId() {
        return productId;
    }

    /**
     * @param productId the productId to set
     */
    public void setProductId(long productId) {
        this.productId = productId;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductDesc() {
        return productDesc;
    }

    public void setProductDesc(String productDesc) {
        this.productDesc = productDesc;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getBizExt() {
        return bizExt;
    }

    public void setBizExt(String bizExt) {
        this.bizExt = bizExt;
    }

    public String getOrderIp() {
        return orderIp;
    }

    public void setOrderIp(String orderIp) {
        this.orderIp = orderIp;
    }

    public String getExtraJson() {
        return extraJson;
    }

    public void setExtraJson(String extraJson) {
        this.extraJson = extraJson;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getRuleDate() {return ruleDate;}

    public void setRuleDate(String ruleDate) {this.ruleDate = ruleDate;}
}
