/**
 * Project: dbservice
 * 
 * File Created at 2014年12月11日
 * gonglijian
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.orm;

import java.util.Date;
import java.util.List;

import com.xunlei.channel.db.pojo.PayNotice;

/**
 * TODO Comment of PayNoticeFailMapper
 * 
 * @author gonglijian
 */
public interface PayNoticeMapper {

    /**
     * @param xunleiPayId
     * @param ruleDate xunleiPayId截取出日期作为mycat分片字段
     * @return
     */
    PayNotice getPayNotice(String xunleiPayId,String ruleDate);

    /**
     * @param payNotice
     */
    void savePayNotice(PayNotice payNotice);

    /**
     * @param payNotice
     */
    void updatePayNotice(PayNotice payNotice);

    /**
     * 得到满足查询条件的通知失败数据
     * @param payNoticeStatus 
     * 
     * @param noticeTime 上次失败的通知时间
     * @param minFailTimes 最少失败次数
     * @param maxFailTimes 最多失败次数
     * @return 失败通知集合
     */
    List<PayNotice> getPayNoticeList(String payNoticeStatus, Date noticeTime, int minFailTimes, int maxFailTimes);

}
