/**
 * Project: dbservice
 * 
 * File Created at 2014年12月11日
 * gonglijian
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.UserDAO;
import com.xunlei.channel.db.orm.UserMapper;
import com.xunlei.channel.db.pojo.User;

/**
 * TODO Comment of UserDAOImpl
 * 
 * @author gonglijian
 */
@Service
public class UserDAOImpl implements UserDAO {
    @Autowired
    private UserMapper userMapper;

    /*
     * (non-Javadoc)
     * @see com.xunlei.channel.db.dao.UserDAO#saveUser()
     */
    @Transactional(readOnly = false)
    @Override
    public void saveUser(User user) throws DataAccessException {
        Assert.notNull(user);
        this.userMapper.saveUser(user);
    }
}
