package com.xunlei.channel.db.dao.impl;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.UserCannotPayOrdersDAO;
import com.xunlei.channel.db.orm.UserCannotPayOrdersMapper;
import com.xunlei.channel.db.pojo.UserCannotPayOrders;

/**
 * Created by ouyangjixin on 2016/5/18.
 */
@Service
public class UserCannotPayOrdersDAOImpl implements UserCannotPayOrdersDAO {

    private final static Logger logger = LoggerFactory.getLogger(UserCannotPayOrdersDAOImpl.class);

    @Autowired
    private UserCannotPayOrdersMapper userCannotPayOrdersMapper;

    @Transactional(readOnly = false)
    @Override
    public void saveUserCannotPayOrders(UserCannotPayOrders userCannotPayOrders) {
        Assert.notNull(userCannotPayOrders);
        logger.info("saveUserCannotPayOrders...xunleiId:{}", userCannotPayOrders.getXunleiId());
        DateFormat format=new SimpleDateFormat("yyyy-MM-dd");
        userCannotPayOrders.setBalanceDate(format.format(new Date()));
        this.userCannotPayOrdersMapper.saveUserCannotPayOrders(userCannotPayOrders);
    }

    @Transactional(readOnly = true)
    @Override
    public boolean isExist(String bizNo, String orderId) {
        logger.info("isExist...bizNo:{}, orderId: {}", bizNo, orderId);
        int count = this.userCannotPayOrdersMapper.isExist(bizNo,orderId);
        if(count > 0){
            return true;
        }
        return false;
    }
}
