/**
 * Project: dbservice
 * 
 * File Created at 2015年1月26日
 * gonglijian
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.dao.TaskResultDAO;
import com.xunlei.channel.db.dao.TaskStatisticDAO;
import com.xunlei.channel.db.orm.TaskResultMapper;
import com.xunlei.channel.db.pojo.TaskResult;
import com.xunlei.channel.db.utils.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.text.SimpleDateFormat;
import java.util.Calendar;

/**
 * TODO Comment of TaskResultDAOImpl
 * 
 * @author gonglijian
 */
@Service
public class TaskResultDAOImpl implements TaskResultDAO {

    private static final Logger logger = LoggerFactory.getLogger(TaskResultDAOImpl.class);

    @Autowired
    private TaskResultMapper    taskResultMapper;

    @Autowired
    private TaskStatisticDAO    taskStatisticDAO;

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.task.core.service.TaskResultService#saveTaskResult
     * (com.xunlei.channel.task.core.pojo.TaskResult)
     */
    @Override
    @Transactional(readOnly = false)
    public void saveTaskResult(TaskResult taskResult) {
        Assert.notNull(taskResult);
        this.taskResultMapper.saveTaskResult(taskResult);
        this.taskStatisticDAO.increaseStatistic(taskResult.getTaskNo(),
                taskResult.getBalanceDate(), taskResult.isOk());

    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.task.core.service.TaskResultService#saveFailResult
     * (java.lang.String, java.lang.String)
     */
    @Override
    public void saveFailResult(String taskNo, String errorMsg) {
        logger.info("saveFailResult...taskNo:{},errorMsg:{}", taskNo, errorMsg);
        Calendar ca = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        TaskResult result = new TaskResult();
        result.setBalanceDate(format.format(ca.getTime()));
        result.setCpuTime(0);
        result.setEndTime(ca.getTime());
        result.setHeapMemory(0);
        result.setNonHeapMemory(0);
        result.setRemark(errorMsg);
        result.setResult(TaskResult.RESULT_FAIL);
        result.setStartTime(ca.getTime());
        result.setTaskNo(taskNo);
        this.saveTaskResult(result);
    }

}
