/**
 * Project: dbservice
 * 
 * File Created at 2015年3月12日
 * lizhaog
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.dao.RiskControlTaskDAO;
import com.xunlei.channel.db.orm.RiskControlTaskMapper;
import com.xunlei.channel.db.pojo.RiskControlTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author lizhaog
 */
@Service
public class RiskControlTaskDAOImpl implements RiskControlTaskDAO {

    @Autowired
    private RiskControlTaskMapper riskControlTaskMapper;

    @Override
    public RiskControlTask getRiskControlTaskByName(String taskName) {
        return riskControlTaskMapper.getRiskControlTaskByName(taskName);
    }

    @Override
    public List<String> getAllTaskName() throws DataAccessException {
        return riskControlTaskMapper.getAllTaskName();
    }

    @Override
    public int getRiskControlTaskCount(String taskName, String inUse, String fromTime, String toTime)
            throws DataAccessException {
        return riskControlTaskMapper.getRiskControlTaskCount(taskName, inUse, fromTime, toTime);
    }

    @Override
    public List<RiskControlTask> getRiskControlTaskList(String taskName, String inUse,
                                                        String fromTime, String toTime,
                                                        String orderBy, String limit)
            throws DataAccessException {
        return riskControlTaskMapper.getRiskControlTaskList(taskName, inUse, fromTime, toTime,
                orderBy, limit);
    }

    @Transactional(readOnly = false)
    @Override
    public void saveRiskControlTask(RiskControlTask riskControlTask) throws DataAccessException {
        riskControlTaskMapper.saveRiskControlTask(riskControlTask);
    }

    @Transactional(readOnly = false)
    @Override
    public void updateRiskControlTask(RiskControlTask riskControlTask) throws DataAccessException {
        riskControlTaskMapper.updateRiskControlTask(riskControlTask);
    }

}
