/**
 * Project: dbservice
 * 
 * File Created at 2014年12月29日
 * gonglijian
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.xunlei.channel.db.common.Constants;
import com.xunlei.channel.db.dao.CustomOrderDAO;
import com.xunlei.channel.db.orm.CustomOrderMapper;
import com.xunlei.channel.db.pojo.CustomOrder;

/**
 * 人工定制表的操作类
 * 
 * @author gonglijian
 */
@Service
public class CustomOrderDAOImpl implements CustomOrderDAO {

    private static final Logger logger = LoggerFactory.getLogger(CustomOrderDAOImpl.class);

    @Autowired
    private CustomOrderMapper   customOrderMapper;

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.CustomOrderDAO#getCustomOrder(java.lang.String)
     */
    @Override
    public CustomOrder getCustomOrder(String xunleiPayId) {
        logger.debug("getCustomOrder...xunleiPayId:{}", xunleiPayId);
        if (null == xunleiPayId) {
            return null;
        }
        return this.customOrderMapper.getCustomOrder(xunleiPayId);
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.CustomOrderDAO#saveCustomOrder(com.xunlei.channel
     * .db.pojo.CustomOrder)
     */
    @Override
    @Transactional(readOnly = false)
    public void saveCustomOrder(CustomOrder customOrder) {
        this.customOrderMapper.saveCustomOrder(customOrder);

    }

    /*
     * (non-Javadoc)
     * @see com.xunlei.channel.db.dao.CustomOrderDAO#listWaitedXunleiPayId()
     */
    @Override
    public List<String> listWaitedXunleiPayId() {
        return this.customOrderMapper.getXunleiPayIdByTypeAndStatus(
                Constants.CUSTOM_ORDER_TYPE_REPAIR, Constants.CUSTOM_ORDER_STATUS_WAIT);
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.CustomOrderDAO#customOrderSuccess(java.lang
     * .String)
     */
    @Override
    @Transactional(readOnly = false)
    public void customOrderSuccess(String xunleiPayId) {
        logger.info("customOrderSuccess...xunleiPayId:{}", xunleiPayId);
        this.customOrderMapper.updateCustomOrderStatus(xunleiPayId,
                Constants.CUSTOM_ORDER_STATUS_SUCCESS, "SUCCESS");
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.CustomOrderDAO#customOrderfailed(java.lang.
     * String, java.lang.String)
     */
    @Override
    @Transactional(readOnly = false)
    public void customOrderfailed(String xunleiPayId, String failMsg) {
        logger.info("customOrderfailed...xunleiPayId:{},failMsg:{}", xunleiPayId, failMsg);
        this.customOrderMapper.updateCustomOrderStatus(xunleiPayId,
                Constants.CUSTOM_ORDER_STATUS_FAIL, failMsg);
    }
}
