package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.utils.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.ChannelAutoPayResultDAO;
import com.xunlei.channel.db.orm.ChannelAutoPayResultMapper;
import com.xunlei.channel.db.pojo.ChannelAutoPayResult;

@Service
public class ChannelAutoPayResultDAOImpl implements ChannelAutoPayResultDAO {

    private final static Logger        logger = LoggerFactory
            .getLogger(ChannelAutoPayResultDAOImpl.class);

    @Autowired
    private ChannelAutoPayResultMapper channelAutoPayResultMapper;

    @Transactional(readOnly = false)
    @Override
    public void saveChannelAutoPayResult(ChannelAutoPayResult channelAutoPayResult)
            throws DataAccessException {
        Assert.notNull(channelAutoPayResult);
        channelAutoPayResultMapper.saveChannelAutoPayResult(channelAutoPayResult);
    }

    @Override
    public ChannelAutoPayResult getChannelAutoPayResult(String xunleiId, String xunleiPayId)
            throws DataAccessException {
        Assert.notNull(xunleiId);
        Assert.notNull(xunleiPayId);
        return channelAutoPayResultMapper.getChannelAutoPayResult(xunleiId, xunleiPayId);
    }

    @Transactional(readOnly = false)
    @Override
    public void updateChannelAutoPayResult(ChannelAutoPayResult channelAutoPayResult)
            throws DataAccessException {
        Assert.notNull(channelAutoPayResult);
        logger.debug("save payOrder...xunleiPayId:{}", channelAutoPayResult.getXunleiId());
        channelAutoPayResultMapper.updateChannelAutoPayResult(channelAutoPayResult);
    }

}
