/**
 * Project: dbservice
 * 
 * File Created at 2014-12-2
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.utils.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.BizAutoPayResultDAO;
import com.xunlei.channel.db.orm.BizAutoPayResultMapper;
import com.xunlei.channel.db.pojo.BizAutoPayResult;

@Service
public class BizAutoPayResultDAOImpl implements BizAutoPayResultDAO {

    private final static Logger                 logger = LoggerFactory.getLogger(BizAutoPayResultDAOImpl.class);

    @Autowired
    private BizAutoPayResultMapper bizAutoPayResultMapper;

    @Transactional(readOnly = false)
    @Override
    public void saveBizAutoPayResult(BizAutoPayResult bizAutoPayResult) throws DataAccessException {
        Assert.notNull(bizAutoPayResult);
        bizAutoPayResultMapper.saveBizAutoPayResult(bizAutoPayResult);
    }

    @Override
    public BizAutoPayResult getBizAutoPayResult(String xunleiId) throws DataAccessException {
        Assert.notNull(xunleiId);
        return bizAutoPayResultMapper.getBizAutoPayResult(xunleiId);
    }

    @Transactional(readOnly = false)
    @Override
    public void updateBizAutoPayResult(BizAutoPayResult bizAutoPayResult)
            throws DataAccessException {
        Assert.notNull(bizAutoPayResult);
        logger.debug("save payOrder...xunleiPayId:{}", bizAutoPayResult.getXunleiId());
        bizAutoPayResultMapper.updateBizAutoPayResult(bizAutoPayResult);
    }

}
