package com.xunlei.channel.db.dao;

import org.springframework.dao.DataAccessException;

import com.xunlei.channel.db.pojo.ChannelAutoPayResult;

public interface ChannelAutoPayResultDAO {
    /**
     * 保存到签约表
     * 
     * @param channelAutoPayResult
     */
    void saveChannelAutoPayResult(ChannelAutoPayResult channelAutoPayResult)
            throws DataAccessException;

    /**
     * 更新签约表
     * 
     * @param channelAutoPayResult
     */
    void updateChannelAutoPayResult(ChannelAutoPayResult channelAutoPayResult)
            throws DataAccessException;

    /**
     * 通过迅雷Id来查找签约表信息
     * 
     * @param xunleiId
     * @return ChannelAutoPayResult or null
     */
    ChannelAutoPayResult getChannelAutoPayResult(String xunleiId, String xunleiPayId)
            throws DataAccessException;

}
