/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.db.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeUtils {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeUtils.class);
    private static final String DATEPATTERN = "yyyy-MM-dd";
    private static final String DATEFORMAT = "yyMMdd";

    public static String initRuleDate() {
        return new SimpleDateFormat(DATEPATTERN).format(new Date());
    }

    public static String spiltRuleDate(String xunleiPayId) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATEPATTERN);
        SimpleDateFormat sdfFormat = new SimpleDateFormat(DATEFORMAT);
        try {
            if (null == xunleiPayId || xunleiPayId.length() == 0) {
                return null;
            }
            return sdf.format(sdfFormat.parse(xunleiPayId.substring(0, 6)));
        }
        catch (Exception e) {
            logger.error("error;DateTimeUtils.spiltRuleDate method:" + e.toString());
            return null;
        }
    }

    public static String formatRuleDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATEPATTERN);
        try {
            if (null == date || date.length() == 0) {
                return sdf.format(new Date());
            }
            try {
                sdf.parse(date);
            }
            catch (ParseException e) {
                return sdf.format(new Date());
            }
        }
        catch (Exception e) {
            logger.error("error;DateTimeUtils.formatRuleDate method:" + e.toString());
        }
        return date;
    }

    public static void initRuleDate(Object obj, String filed) {
        try {
            Class<?> clazz = obj.getClass();
            PropertyDescriptor pd = new PropertyDescriptor(filed, clazz);
            Method method = pd.getReadMethod();
            if (pd != null) {
                Object o = method.invoke(obj, new Object[0]);
                String ruleDate = DateTimeUtils.formatRuleDate(o == null ? "" : o.toString());
                Field[] fields = clazz.getDeclaredFields();
                boolean isContain = false;
                for (Field fReult : fields) {
                    if (!fReult.getName().equals(filed)) continue;
                    isContain = true;
                    break;
                }
                Field f = null;
                f = isContain ? obj.getClass().getDeclaredField(filed) : obj.getClass().getSuperclass().getDeclaredField(filed);
                f.setAccessible(true);
                f.set(obj, ruleDate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error;DateTimeUtils.initRuleDate method:" + e.toString());
        }
    }
}

