/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.dao.PayOrderOkDAO;
import com.xunlei.channel.db.orm.PayOrderOkMapper;
import com.xunlei.channel.db.pojo.PayOrderOk;
import com.xunlei.channel.db.utils.DateTimeUtils;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PayOrderOkDAOImpl
implements PayOrderOkDAO {
    private static final Logger logger = LoggerFactory.getLogger(PayOrderOkDAOImpl.class);
    @Autowired
    private PayOrderOkMapper payOrderOkMapper;

    @Override
    @Transactional(readOnly=false)
    public void savePayOrderOk(PayOrderOk payOrderOk) throws DataAccessException {
        Assert.notNull((Object)payOrderOk);
        payOrderOk.setRuleDate(DateTimeUtils.spiltRuleDate(payOrderOk.getXunleiPayId()));
        Assert.notNull((Object)payOrderOk.getRuleDate());
        this.payOrderOkMapper.savePayOrderOk(payOrderOk);
    }

    @Override
    public PayOrderOk getPayOrderOk(String xunleiPayId) throws DataAccessException {
        Assert.notNull((Object)xunleiPayId);
        String ruleDate = DateTimeUtils.spiltRuleDate(xunleiPayId);
        Assert.notNull((Object)ruleDate);
        return this.payOrderOkMapper.getPayOrderOk(xunleiPayId, ruleDate);
    }

    @Override
    @Transactional(readOnly=false)
    public void updatePayOrderOk(PayOrderOk payOrderOk) throws DataAccessException {
        Assert.notNull((Object)payOrderOk);
        payOrderOk.setRuleDate(DateTimeUtils.spiltRuleDate(payOrderOk.getXunleiPayId()));
        Assert.notNull((Object)payOrderOk.getRuleDate());
        logger.debug("save payOrderOk...xunleiPayId:{}", (Object)payOrderOk.getXunleiPayId());
        this.payOrderOkMapper.updatePayOrderOk(payOrderOk);
    }

    @Override
    public PayOrderOk getPayOrderOkByBizNoAndBizOrderId(String bizNo, String bizOrderId) throws DataAccessException {
        Assert.notNull((Object)bizNo);
        Assert.notNull((Object)bizOrderId);
        return this.payOrderOkMapper.getPayOrderOkByBizNoAndBizOrderId(bizNo, bizOrderId);
    }

    @Override
    public PayOrderOk getPayOrderOkByBizOrderId(String bizOrderId) {
        Assert.notNull((Object)bizOrderId);
        return this.payOrderOkMapper.getPayOrderOkByBizOrderId(bizOrderId);
    }

    @Override
    public String getPayOrderOkSendNoticeStatus(String xunleiPayId) throws DataAccessException {
        Assert.notNull((Object)xunleiPayId);
        String ruleDate = DateTimeUtils.spiltRuleDate(xunleiPayId);
        Assert.notNull((Object)ruleDate);
        return this.payOrderOkMapper.getPayOrderOkSendNoticeStatus(xunleiPayId, ruleDate);
    }

    @Override
    @Transactional(readOnly=false)
    public void updateSendNoticeStatus(String xunleiPayId, String sendNoticeStatus) throws DataAccessException {
        Assert.notNull((Object)xunleiPayId);
        Assert.notNull((Object)sendNoticeStatus);
        String ruleDate = DateTimeUtils.spiltRuleDate(xunleiPayId);
        Assert.notNull((Object)ruleDate);
        this.payOrderOkMapper.updateSendNoticeStatus(xunleiPayId, sendNoticeStatus, ruleDate);
    }

    @Override
    public List<String> listUnsuccessNoticeXunleiPayId(Date fromTime, Date endTime) throws DataAccessException {
        if (null == fromTime && null == endTime) {
            return null;
        }
        return this.payOrderOkMapper.listUnsuccessNoticeXunleiPayId("F", fromTime, endTime);
    }

    @Override
    public int getCountByPhoneBizNoAndDate(String phone, String bizNo, Date fromDate, Date toDate) throws DataAccessException {
        Assert.notNull((Object)phone);
        Assert.notNull((Object)bizNo);
        Assert.notNull((Object)fromDate);
        Assert.notNull((Object)toDate);
        return this.payOrderOkMapper.getCountByPhoneBizNoAndDate(phone, bizNo, fromDate, toDate);
    }

    @Override
    public int getSumPayAmountByXunleiIdBizNoAndDate(String xunleiId, String bizNo, Date fromDate, Date toDate) throws DataAccessException {
        Integer sum = this.payOrderOkMapper.getSumPayAmountByXunleiIdBizNoAndDate(xunleiId, bizNo, fromDate, toDate);
        return sum == null ? 0 : sum;
    }

    @Override
    public int getCountByXunleiIdBizNoAndDate(String xunleiId, String bizNo, Date fromDate, Date toDate) throws DataAccessException {
        return this.payOrderOkMapper.getCountByXunleiIdBizNoAndDate(xunleiId, bizNo, fromDate, toDate);
    }

    @Override
    public PayOrderOk getPayOrderOkByPayTypeAndChannelOrderId(String payType, String channelOrderId) throws DataAccessException {
        Assert.notNull((Object)payType);
        Assert.hasText((String)channelOrderId, (String)"channelOrderId could not be null!");
        return this.payOrderOkMapper.getPayOrderOkByPayTypeAndChannelOrderId(payType, channelOrderId);
    }

    @Override
    public PayOrderOk getFirstPayOrderOkByXunleiIdAndPayType(String xunleiId, String payType) throws DataAccessException {
        Assert.hasText((String)xunleiId, (String)"xunleiId could not be null!");
        Assert.hasText((String)payType, (String)"payType could not be null!");
        return this.payOrderOkMapper.getFirstPayOrderOkByXunleiIdAndPayType(xunleiId, payType);
    }

    @Override
    public PayOrderOk getLastPayOrderOkByXunleiIdAndPayType(String xunleiId, String payType) throws DataAccessException {
        Assert.hasText((String)xunleiId, (String)"xunleiId could not be null!");
        Assert.hasText((String)payType, (String)"payType could not be null!");
        return this.payOrderOkMapper.getLastPayOrderOkByXunleiIdAndPayType(xunleiId, payType);
    }

    @Override
    public long getSumOfOrderByXunleiIdAndDate(String xunleiId, Date fromDate, Date toDate) {
        Assert.notNull((Object)xunleiId);
        Long sum = this.payOrderOkMapper.getSumOfOrderByXunleiIdAndDate(xunleiId, fromDate, toDate);
        return sum == null ? 0L : sum;
    }

    @Override
    public long getSumOfOrderByXunleiIdPayTypeAndDate(String xunleiId, String payType, Date fromDate, Date toDate) {
        Assert.notNull((Object)xunleiId);
        Long sum = this.payOrderOkMapper.getSumOfOrderByXunleiIdPayTypeAndDate(xunleiId, payType, fromDate, toDate);
        return sum == null ? 0L : sum;
    }
}

