/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.dao.PayOrderFailDAO;
import com.xunlei.channel.db.orm.PayOrderFailMapper;
import com.xunlei.channel.db.pojo.PayOrderFail;
import com.xunlei.channel.db.utils.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PayOrderFailDAOImpl
implements PayOrderFailDAO {
    private static final Logger logger = LoggerFactory.getLogger(PayOrderFailDAOImpl.class);
    @Autowired
    private PayOrderFailMapper payOrderFailMapper;

    @Override
    @Transactional(readOnly=false)
    public void savePayOrderFail(PayOrderFail payOrderFail) throws DataAccessException {
        Assert.notNull((Object)payOrderFail);
        payOrderFail.setRuleDate(DateTimeUtils.spiltRuleDate(payOrderFail.getXunleiPayId()));
        Assert.notNull((Object)payOrderFail.getRuleDate());
        this.payOrderFailMapper.savePayOrderFail(payOrderFail);
    }

    @Override
    public PayOrderFail getPayOrderFail(String xunleiPayId) throws DataAccessException {
        Assert.notNull((Object)xunleiPayId);
        String ruleDate = DateTimeUtils.spiltRuleDate(xunleiPayId);
        Assert.notNull((Object)ruleDate);
        return this.payOrderFailMapper.getPayOrderFail(xunleiPayId, ruleDate);
    }

    @Override
    @Transactional(readOnly=false)
    public void updatePayOrderFail(PayOrderFail payOrderFail) throws DataAccessException {
        Assert.notNull((Object)payOrderFail);
        payOrderFail.setRuleDate(DateTimeUtils.spiltRuleDate(payOrderFail.getXunleiPayId()));
        Assert.notNull((Object)payOrderFail.getRuleDate());
        logger.debug("save payOrderFail...xunleiPayId:{}", (Object)payOrderFail.getXunleiPayId());
        this.payOrderFailMapper.updatePayOrderFail(payOrderFail);
    }
}

