/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.orm.PayOrderMapper;
import com.xunlei.channel.db.pojo.PayOrder;
import com.xunlei.channel.db.utils.DateTimeUtils;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PayOrderDAOImpl
implements PayOrderDAO {
    private static final Logger logger = LoggerFactory.getLogger(PayOrderDAOImpl.class);
    @Autowired
    private PayOrderMapper payOrderMapper;

    @Override
    @Transactional(readOnly=false)
    public void savePayOrder(PayOrder payOrder) throws DataAccessException {
        Assert.notNull((Object)payOrder);
        Assert.notNull((Object)payOrder.getXunleiPayId());
        payOrder.setRuleDate(DateTimeUtils.spiltRuleDate(payOrder.getXunleiPayId()));
        Assert.notNull((Object)payOrder.getRuleDate());
        logger.info("savePayOrder...xunleiPayId:{}", (Object)payOrder.getXunleiPayId());
        this.payOrderMapper.savePayOrder(payOrder);
    }

    @Override
    public PayOrder getPayOrder(String xunleiPayId) throws DataAccessException {
        Assert.notNull((Object)xunleiPayId);
        String ruleDate = DateTimeUtils.spiltRuleDate(xunleiPayId);
        Assert.notNull((Object)ruleDate);
        return this.payOrderMapper.getPayOrder(xunleiPayId, ruleDate);
    }

    @Override
    public void updateExtraJsonByXunleiPayId(String extraJson, String xunleiPayId) {
        Assert.notNull((Object)xunleiPayId);
        String ruleDate = DateTimeUtils.spiltRuleDate(xunleiPayId);
        Assert.notNull((Object)ruleDate);
        this.payOrderMapper.updateExtraJsonByXunleiPayId(extraJson, xunleiPayId, ruleDate);
    }

    @Override
    @Transactional(readOnly=false)
    public void updateBizExtByXunleiPayId(String bizExt, String xunleiPayId) {
        Assert.notNull((Object)xunleiPayId);
        String ruleDate = DateTimeUtils.spiltRuleDate(xunleiPayId);
        Assert.notNull((Object)ruleDate);
        this.payOrderMapper.updateBizExtByXunleiPayId(bizExt, xunleiPayId, ruleDate);
    }

    @Override
    public PayOrder getPayOrderByBizNoAndBizOrderId(String bizNo, String bizOrderId) throws DataAccessException {
        Assert.notNull((Object)bizNo);
        Assert.notNull((Object)bizOrderId);
        return this.payOrderMapper.getPayOrderByBizNoAndBizOrderId(bizNo, bizOrderId);
    }

    @Override
    public int getCountByBizNoAndBizOrderId(String bizNo, String bizOrderId) throws DataAccessException {
        Assert.notNull((Object)bizOrderId);
        Assert.notNull((Object)bizNo);
        Integer count = this.payOrderMapper.getCountByBizNoAndBizOrderId(bizNo, bizOrderId);
        return count == null ? 0 : count;
    }

    @Override
    @Transactional(readOnly=false)
    public void updatePayOrderStatusAndChannelId(String xunleiPayId, String orderStatus, String channelOrderId) throws DataAccessException {
        Assert.notNull((Object)xunleiPayId);
        Assert.notNull((Object)orderStatus);
        String ruleDate = DateTimeUtils.spiltRuleDate(xunleiPayId);
        Assert.notNull((Object)ruleDate);
        this.payOrderMapper.updatePayOrderStatusAndChannelId(xunleiPayId, orderStatus, channelOrderId, ruleDate);
    }

    @Override
    public void updatePayOrderStatusAndChannelIdAndExtraJson(String xunleiPayId, String orderStatus, String channelOrderId, String extraJson) throws DataAccessException {
        Assert.notNull((Object)xunleiPayId);
        Assert.notNull((Object)orderStatus);
        Assert.notNull((Object)extraJson);
        String ruleDate = DateTimeUtils.spiltRuleDate(xunleiPayId);
        Assert.notNull((Object)ruleDate);
        this.payOrderMapper.updatePayOrderStatusAndChannelIdAndExtraJson(xunleiPayId, orderStatus, channelOrderId, extraJson, ruleDate);
    }

    @Override
    public List<PayOrder> getPayOrderByMinIdAndStatus(long id, String[] status, int limit) throws DataAccessException {
        Assert.notNull((Object)id);
        Assert.notNull((Object)status);
        return this.payOrderMapper.getPayOrderByMinIdAndStatus(id, status, limit);
    }

    @Override
    public List<PayOrder> getPayOrderByCreateTime(String fromTime, String toTime, String[] status, long id, int limit) throws DataAccessException {
        Assert.notNull((Object)fromTime);
        Assert.notNull((Object)toTime);
        return this.payOrderMapper.getPayOrderByCreateTime(fromTime, toTime, status, id, limit);
    }

    @Override
    @Transactional(readOnly=false)
    public void updatePayOrderExtraJsonAndChannelId(String xunleiPayId, String extraJson, String channelOrderId) throws DataAccessException {
        Assert.notNull((Object)xunleiPayId);
        Assert.notNull((Object)extraJson);
        Assert.notNull((Object)channelOrderId);
        String ruleDate = DateTimeUtils.spiltRuleDate(xunleiPayId);
        Assert.notNull((Object)ruleDate);
        this.payOrderMapper.updatePayOrderExtraJsonAndChannelId(xunleiPayId, extraJson, channelOrderId, ruleDate);
    }

    @Override
    public int getCountOfOrderRequestByXunleiIdBizNoAndDate(String xunleiId, String bizNo, Date fromDate, Date toDate) {
        Integer count = this.payOrderMapper.getCountOfOrderRequestByXunleiIdBizNoAndDate(xunleiId, bizNo, fromDate, toDate);
        return count == null ? 0 : count;
    }

    @Override
    public PayOrder getPayOrderByPayTypeAndChannelOrderId(String payType, String channelOrderId) throws DataAccessException {
        Assert.notNull((Object)payType);
        Assert.notNull((Object)channelOrderId);
        return this.payOrderMapper.getPayOrderByPayTypeAndChannelOrderId(payType, channelOrderId);
    }

    @Override
    @Transactional(readOnly=false)
    public void updatePhoneByXunleiPayId(String xunleiPayId, String phone) {
        Assert.notNull((Object)xunleiPayId);
        Assert.notNull((Object)phone);
        String ruleDate = DateTimeUtils.spiltRuleDate(xunleiPayId);
        Assert.notNull((Object)ruleDate);
        this.payOrderMapper.updatePhoneByXunleiPayId(xunleiPayId, phone, ruleDate);
    }

    @Override
    public void updatePayOrderRemark(String xunleiPayId, String remark) {
        Assert.notNull((Object)xunleiPayId);
        String ruleDate = DateTimeUtils.spiltRuleDate(xunleiPayId);
        Assert.notNull((Object)ruleDate);
        this.payOrderMapper.updatePayOrderRemark(xunleiPayId, remark, ruleDate);
    }
}

