/**
 * Project: dbservice
 * <p/>
 * File Created at 2015年3月12日
 * lizhaog
 * <p/>
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 * <p/>
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.dao.RiskControlResultDAO;
import com.xunlei.channel.db.orm.RiskControlResultMapper;
import com.xunlei.channel.db.pojo.RiskControlResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Map;

/**
 * @author lizhaog
 */
@Service
public class RiskControlResultDAOImpl implements RiskControlResultDAO {

    @Autowired
    private RiskControlResultMapper riskControlResultMapper;

    @Transactional(readOnly = false)
    @Override
    public void saveRiskControlResult(RiskControlResult riskControlResult)
            throws DataAccessException {
        Assert.notNull(riskControlResult);
        this.riskControlResultMapper.saveRiskControlResult(riskControlResult);
    }

    @Override
    public RiskControlResult getRiskControlResult(String dataId, String taskName)
            throws DataAccessException {
        Assert.notNull(dataId);
        Assert.notNull(taskName);
        return this.riskControlResultMapper.getRiskControlResult(dataId, taskName);
    }

    @Override
    public RiskControlResult getRiskControlResultById(long id) throws DataAccessException {
        Assert.notNull(id);
        return this.riskControlResultMapper.getRiskControlResultById(id);
    }

    @Transactional(readOnly = false)
    @Override
    public void updateRiskControlResult(RiskControlResult riskControlResult)
            throws DataAccessException {
        Assert.notNull(riskControlResult);
        Assert.notNull(riskControlResult.getDataId());
        Assert.notNull(riskControlResult.getTaskName());
        this.riskControlResultMapper.updateRiskControlResult(riskControlResult);
    }

    @Override
    public List<RiskControlResult> getRiskControlResultByValueAndAlarmLevel(String resusltValue,
                                                                            String[] alarmLevel,
                                                                            int limit)
            throws DataAccessException {
        Assert.notNull(resusltValue);
        Assert.notNull(alarmLevel);
        Assert.notNull(limit);
        return this.riskControlResultMapper.getRiskControlResultByValueAndAlarmLevel(resusltValue,
                alarmLevel, limit);
    }

    @Override
    public int getRiskControlResultCount(String taskName, String resultValue, String dataId,
                                         String alarmLevel, String fromTime, String toTime)
            throws DataAccessException {
        return this.riskControlResultMapper.getRiskControlResultCount(taskName, resultValue,
                dataId, alarmLevel, fromTime, toTime);
    }

    @Override
    public List<RiskControlResult> getRiskControlResultList(Map<String, Object> paramsMap) {
        return this.riskControlResultMapper.getRiskControlResultList(paramsMap);
    }


    @Override
    public void delRiskControlResult(Map<String, Object> paramsMap) {
        riskControlResultMapper.delRiskControlResult(paramsMap);
    }
}
