/**
 * Project: dbservice
 * 
 * File Created at 2014年12月11日
 * gonglijian
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.dao.PayNoticeDAO;
import com.xunlei.channel.db.orm.PayNoticeMapper;
import com.xunlei.channel.db.pojo.PayNotice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Date;
import java.util.List;

/**
 * TODO Comment of PayNoticeFailDAOImpl
 * 
 * @author gonglijian
 */
@Service
public class PayNoticeDAOImpl implements PayNoticeDAO {
    private final static Logger          logger = LoggerFactory.getLogger(PayNoticeDAOImpl.class);
    @Autowired
    private PayNoticeMapper payNoticeMapper;

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.PayNoticeFailDAO#getPayNoticeFail(java.lang
     * .String)
     */
    @Override
    public PayNotice getPayNotice(String xunleiPayId) throws DataAccessException {
        Assert.notNull(xunleiPayId);
        logger.debug("getPayNoticeFail...xunleiPayId:{}", xunleiPayId);
        return this.payNoticeMapper.getPayNotice(xunleiPayId);
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.PayNoticeFailDAO#savePayNoticeFail(com.xunlei
     * .channel.db.pojo.PayNoticeFail)
     */
    @Transactional(readOnly = false)
    @Override
    public void savePayNotice(PayNotice payNotice) throws DataAccessException {
        Assert.notNull(payNotice);
        logger.debug("savePayNoticeFail...xunleiPayId:{}", payNotice.getXunleiPayId());
        this.payNoticeMapper.savePayNotice(payNotice);
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.PayNoticeFailDAO#updatePayNoticeFail(com.xunlei
     * .channel.db.pojo.PayNoticeFail)
     */
    @Transactional(readOnly = false)
    @Override
    public void updatePayNotice(PayNotice payNotice) throws DataAccessException {
        Assert.notNull(payNotice);
        logger.debug("updatePayNoticeFail...xunleiPayId:{}", payNotice.getXunleiPayId());
        this.payNoticeMapper.updatePayNotice(payNotice);
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.PayNoticeFailDAO#getPayNoticeFailList(java.
     * util.Date, int, int)
     */
    @Override
    public List<PayNotice> getPayNoticeList(String payNoticeStatus, Date noticeTime,
                                                int minFailTimes, int maxFailTimes)
            throws DataAccessException {
        return this.payNoticeMapper.getPayNoticeList(payNoticeStatus,noticeTime, minFailTimes, maxFailTimes);
    }

}
