/**
 * Project: dbservice
 * File Created at 2014-12-1
 * laiquan.luolq
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao;

import java.util.Date;
import java.util.List;

import org.springframework.dao.DataAccessException;

import com.xunlei.channel.db.pojo.PayOrderOk;

/**
 * 成功订单操作
 *
 * @author lishaojun
 */
public interface PayOrderOkDAO {

    /**
     * 保存请求订单信息到数据库
     *
     * @param biz
     * @throws DataAccessException
     */
    void savePayOrderOk(PayOrderOk payOrderOk) throws DataAccessException;

    /**
     * 更新请求订单
     *
     * @param payOrderOk
     */
    void updatePayOrderOk(PayOrderOk payOrderOk) throws DataAccessException;

    /**
     * 通过xunleiPayId获得请求订单的实体
     *
     * @param xunleiPayId
     * @return PayOrder
     * @throws DataAccessException
     */
    PayOrderOk getPayOrderOk(String xunleiPayId) throws DataAccessException;

    /**
     * @param bizNo
     * @param bizOrderId
     * @return
     */
    PayOrderOk getPayOrderOkByBizNoAndBizOrderId(String bizNo, String bizOrderId)
            throws DataAccessException;

    /**
     * 根据业务方唯一订单号获取成功订单
     *
     * @param bizOrderId
     * @return
     */
    PayOrderOk getPayOrderOkByBizOrderId(String bizOrderId);

    /**
     * 得到成功订单表里的send_notice_status值
     *
     * @param xunleiPayId
     * @return send_notice_status值
     */
    String getPayOrderOkSendNoticeStatus(String xunleiPayId) throws DataAccessException;

    /**
     * 更新send_notice_status值
     *
     * @param xunleiPayId
     * @param sendNoticeStatus
     */
    void updateSendNoticeStatus(String xunleiPayId, String sendNoticeStatus)
            throws DataAccessException;

    /**
     * @param fromTime
     * @param endTime
     * @return
     */
    List<String> listUnsuccessNoticeXunleiPayId(Date fromTime, Date endTime)
            throws DataAccessException;

    /**
     * 根据手机号、业务号、开始日期、结束日期查询订单数量
     *
     * @param phone 手机号
     * @param bizNo 业务号
     * @param fromDate 开始日期
     * @param toDate 结束日期
     * @return 订单数
     * @throws DataAccessException
     */
    int getCountByPhoneBizNoAndDate(String phone, String bizNo, Date fromDate, Date toDate)
            throws DataAccessException;

    /**
     * 获取用户一定日期内的成功订单总金额（必须以分为单位）
     *
     * @param xunleiId 迅雷id
     * @param bizNo 业务编号
     * @param fromDate 开始日期
     * @param toDate 结束日期
     * @return
     * @throws DataAccessException
     */
    int getSumPayAmountByXunleiIdBizNoAndDate(String xunleiId, String bizNo, Date fromDate,
                                              Date toDate) throws DataAccessException;

    /**
     * 帐号内一定时间内的成功次数
     *
     * @param xunleiId 迅雷Id
     * @param bizNo 业务编号
     * @param fromDate 开始日期
     * @param toDate 结束日期
     * @return
     * @throws DataAccessException
     */
    int getCountByXunleiIdBizNoAndDate(String xunleiId, String bizNo, Date fromDate, Date toDate)
            throws DataAccessException;

    PayOrderOk getPayOrderOkByPayTypeAndChannelOrderId(String payType, String channelOrderId)
            throws DataAccessException;

    /**
     * 根据xunleiId获取第一次使用<b>payType</b>支付的成功订单
     *
     * @param xunleiId 迅雷Id
     * @param payType 支付方式
     * @return {@link PayOrderOk}
     * @throws DataAccessException
     */
    PayOrderOk getFirstPayOrderOkByXunleiIdAndPayType(String xunleiId, String payType)
            throws DataAccessException;

    /**
     * 根据xunleiId获取最后一次使用<b>payType</b>支付的有channelOrderId的成功订单
     *
     * @param xunleiId 迅雷Id
     * @param payType 支付方式
     * @return {@link PayOrderOk}
     * @throws DataAccessException
     */
    PayOrderOk getLastPayOrderOkByXunleiIdAndPayType(String xunleiId, String payType)
            throws DataAccessException;

    /**
     * 获取用户一定日期内的订单金额
     * 
     * @param xunleiId 迅雷ID
     * @param fromDate 开始日期
     * @param toDate 结束日期
     * @return {@link Long}
     */
    long getSumOfOrderByXunleiIdAndDate(String xunleiId, Date fromDate, Date toDate);

    /**
     * 获取用户一定日期内支付类型的订单金额
     * @param xunleiId 迅雷ID
     * @param payType 支付方式
     * @param fromDate 开始日期
     * @param toDate 结束日期
     * @return {@link Long}
     */
    long getSumOfOrderByXunleiIdPayTypeAndDate(String xunleiId,String payType, Date fromDate, Date toDate);
}
