/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.dao.PayNoticeDAO;
import com.xunlei.channel.db.orm.PayNoticeMapper;
import com.xunlei.channel.db.pojo.PayNotice;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PayNoticeDAOImpl
implements PayNoticeDAO {
    private static final Logger logger = LoggerFactory.getLogger(PayNoticeDAOImpl.class);
    @Autowired
    private PayNoticeMapper payNoticeMapper;

    @Override
    public PayNotice getPayNotice(String xunleiPayId) throws DataAccessException {
        Assert.notNull((Object)xunleiPayId);
        logger.debug("getPayNoticeFail...xunleiPayId:{}", (Object)xunleiPayId);
        return this.payNoticeMapper.getPayNotice(xunleiPayId);
    }

    @Override
    @Transactional(readOnly=false)
    public void savePayNotice(PayNotice payNotice) throws DataAccessException {
        Assert.notNull((Object)payNotice);
        logger.debug("savePayNoticeFail...xunleiPayId:{}", (Object)payNotice.getXunleiPayId());
        this.payNoticeMapper.savePayNotice(payNotice);
    }

    @Override
    @Transactional(readOnly=false)
    public void updatePayNotice(PayNotice payNotice) throws DataAccessException {
        Assert.notNull((Object)payNotice);
        logger.debug("updatePayNoticeFail...xunleiPayId:{}", (Object)payNotice.getXunleiPayId());
        this.payNoticeMapper.updatePayNotice(payNotice);
    }

    @Override
    public List<PayNotice> getPayNoticeList(String payNoticeStatus, Date noticeTime, int minFailTimes, int maxFailTimes) throws DataAccessException {
        return this.payNoticeMapper.getPayNoticeList(payNoticeStatus, noticeTime, minFailTimes, maxFailTimes);
    }
}

