/**
 *
 */
package com.xunlei.channel.db.orm;

import com.xunlei.channel.db.pojo.PayOrderOk;
import org.springframework.dao.DataAccessException;

import java.util.Date;
import java.util.List;

/**
 * @author gonglijian
 */
public interface PayOrderOkMapper {

    /**
     * 保持成功订单信息到订单成功表
     *
     * @param payOrderOk
     */
    void savePayOrderOk(PayOrderOk payOrderOk);

    /**
     * 保存到成功
     *
     * @param payOrderOk
     */
    void updatePayOrderOk(PayOrderOk payOrderOk);

    /**
     * 得到成功订单的所有信息
     *
     * @param xunleiPayId
     * @return PayOrderOk or null
     */
    PayOrderOk getPayOrderOk(String xunleiPayId);

    /**
     * @param bizNo
     * @param bizOrderId
     * @return
     */
    PayOrderOk getPayOrderOkByBizNoAndBizOrderId(String bizNo, String bizOrderId);

    /**
     * 根据业务方唯一订单号获取成功订单
     *
     * @param bizOrderId
     * @return
     */
    PayOrderOk getPayOrderOkByBizOrderId(String bizOrderId);

    /**
     * 得到成功订单的通知状态信息
     *
     * @param xunleiPayId
     * @return noticeStatus of the PayOrderOk
     */
    String getPayOrderOkSendNoticeStatus(String xunleiPayId);

    /**
     * @param xunleiPayId
     * @param sendNoticeStatus
     */
    void updateSendNoticeStatus(String xunleiPayId, String sendNoticeStatus);

    /**
     * @param sendNoticeStatus
     * @param fromTime
     * @param endTime
     * @return
     */
    List<String> listUnsuccessNoticeXunleiPayId(String sendNoticeStatus, Date fromTime,
                                                Date endTime);

    /**
     * 根据手机号、业务号、开始日期、结束日期查询订单数量
     *
     * @param phone 手机号
     * @param bizNo 业务号
     * @param fromDate 开始日期
     * @param toDate 结束日期
     * @return 订单数
     */
    Integer getCountByPhoneBizNoAndDate(String phone, String bizNo, Date fromDate, Date toDate);

    /**
     * 获取用户一定日期内的成功订单总金额（必须以分为单位）
     *
     * @param xunleiId 迅雷id
     * @param bizNo 业务编号
     * @param fromDate 开始日期
     * @param toDate 结束日期
     * @return
     * @throws DataAccessException
     */
    Integer getSumPayAmountByXunleiIdBizNoAndDate(String xunleiId, String bizNo, Date fromDate,
                                                  Date toDate);

    /**
     * 查询帐号一定时间内的成功次数
     *
     * @param xunleiId 迅雷Id
     * @param bizNo 业务编号
     * @param fromDate 开始日期
     * @param toDate 结束日期
     * @return
     * @throws DataAccessException
     */
    Integer getCountByXunleiIdBizNoAndDate(String xunleiId, String bizNo, Date fromDate,
                                           Date toDate);

    PayOrderOk getPayOrderOkByPayTypeAndChannelOrderId(String payType, String channelOrderId);

    /**
     * 根据xunleiId获取第一次使用<b>payType</b>支付的成功订单
     *
     * @param xunleiId 迅雷Id
     * @param payType 支付方式
     * @return {@link PayOrderOk}
     * @throws DataAccessException
     */
    PayOrderOk getFirstPayOrderOkByXunleiIdAndPayType(String xunleiId, String payType);

    /**
     * 根据xunleiId获取最后一次使用<b>payType</b>支付的有channelOrderId的成功订单
     *
     * @param xunleiId 迅雷Id
     * @param payType 支付方式
     * @return {@link PayOrderOk}
     * @throws DataAccessException
     */
    PayOrderOk getLastPayOrderOkByXunleiIdAndPayType(String xunleiId, String payType);

    /**
     * 获取用户一定日期内的订单金额
     * 
     * @param xunleiId 迅雷ID
     * @param fromDate 开始日期
     * @param toDate 结束日期
     * @return
     */
    Long getSumOfOrderByXunleiIdAndDate(String xunleiId, Date fromDate, Date toDate);

    /**
     * 获取用户一定日期内支付类型的订单金额
     * @param xunleiId 迅雷ID
     * @param payType 支付方式
     * @param fromDate 开始日期
     * @param toDate 结束日期
     * @return {@link Long}
     */
    Long getSumOfOrderByXunleiIdPayTypeAndDate(String xunleiId, String payType, Date fromDate, Date toDate);
}
