/**
 * 
 */
package com.xunlei.channel.db.orm;

import java.util.List;

import com.xunlei.channel.db.pojo.ContactResult;

/**
 * @author lishaojun
 */
public interface ContactResultMapper {

    /**
     * 保存到签约表
     * 
     * @param ContactResult
     */
    void saveContactResult(ContactResult contactResult);

    /**
     * 更新签约表
     * 
     * @param ContactResult
     */
    void updateContactResult(ContactResult contactResult);

    /**
     * 查询所有的签约表信息
     * 
     * @return List
     */
    List<ContactResult> listAllContactResult();

    /**
     * 通过迅雷Id和签约号来查找签约表信息
     * 
     * @param xunleiId
     * @return ContactResult or null
     */
    ContactResult getContactResultbySignNo(String xunleiId, String signNo);

    /**
     * 通过多个条件来查找唯一结果
     * 
     * @param xunleiId
     * @param payType
     * @param contactType
     * @param status
     * @return ContactResult or null
     */
    ContactResult getTheContactResult(String xunleiId, String payType, String contactType,
                                      String status);

    /**
     * 通过xunleiID和支付类型查找签约解约关系，原则上最多只会有一条记录
     * 
     * @param xunleiId
     * @param payType
     * @return ContactResult or null
     */
    ContactResult getContactResultByXunleiIdAndPayType(String xunleiId, String payType);

}
