package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.dao.UserCannotPayOrdersDAO;
import com.xunlei.channel.db.orm.UserCannotPayOrdersMapper;
import com.xunlei.channel.db.pojo.UserCannotPayOrders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/**
 * Created by ouyangjixin on 2016/5/18.
 */
@Service
public class UserCannotPayOrdersDAOImpl implements UserCannotPayOrdersDAO {

    private final static Logger logger = LoggerFactory.getLogger(UserCannotPayOrdersDAOImpl.class);

    @Autowired
    private UserCannotPayOrdersMapper userCannotPayOrdersMapper;

    @Transactional(readOnly = false)
    @Override
    public void saveUserCannotPayOrders(UserCannotPayOrders userCannotPayOrders) {
        Assert.notNull(userCannotPayOrders);
        logger.info("saveUserCannotPayOrders...xunleiId:{}", userCannotPayOrders.getXunleiId());
        this.userCannotPayOrdersMapper.saveUserCannotPayOrders(userCannotPayOrders);
    }
}
