/**
 * Project: db-service
 * 
 * File Created at 2016年4月12日
 * gonglijian
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.xunlei.channel.db.dao.ContactLogDAO;
import com.xunlei.channel.db.orm.ContactLogMapper;
import com.xunlei.channel.db.pojo.ContactLog;

/**
 * 签约|解约日志表
 * 
 * @author gonglijian
 */
@Service
public class ContactLogDAOImpl implements ContactLogDAO {
    @Autowired
    private ContactLogMapper contactLogMapper;

    /**
     * 保存到数据库
     */
    @Transactional(readOnly = false)
    @Override
    public void saveContactLog(ContactLog log) {
        this.contactLogMapper.saveContactLog(log);
    }

    @Override
    public List<ContactLog> listContactLogByXunleiId(String xunleiId) {
        return this.contactLogMapper.listContactLogByXunleiId(xunleiId);
    }
}
