package com.xunlei.channel.db.dao.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.ChannelAutoPayQuitDAO;
import com.xunlei.channel.db.orm.ChannelAutoPayQuitMapper;
import com.xunlei.channel.db.pojo.ChannelAutoPayQuit;

@Service
public class ChannelAutoPayQuitDAOImpl implements ChannelAutoPayQuitDAO {

    private final static Logger                   logger = LoggerFactory.getLogger(ChannelAutoPayQuitDAOImpl.class);

    @Autowired
    private ChannelAutoPayQuitMapper channelAutoPayQuitMapper;

    @Transactional(readOnly = false)
    @Override
    public void saveChannelAutoPayQuit(ChannelAutoPayQuit channelAutoPayQuit)
            throws DataAccessException {
        channelAutoPayQuitMapper.saveChannelAutoPayQuit(channelAutoPayQuit);
    }

    @Override
    public ChannelAutoPayQuit getChannelAutoPayQuit(String xunleiPayId) throws DataAccessException {
        Assert.notNull(xunleiPayId);
        return channelAutoPayQuitMapper.getChannelAutoPayQuit(xunleiPayId);
    }

    @Transactional(readOnly = false)
    @Override
    public void updateChannelAutoPayQuit(ChannelAutoPayQuit channelAutoPayQuit)
            throws DataAccessException {
        Assert.notNull(channelAutoPayQuit);
        logger.debug("save payOrder...xunleiPayId:{}", channelAutoPayQuit.getXunleiId());
        channelAutoPayQuitMapper.updateChannelAutoPayQuit(channelAutoPayQuit);
    }

}
