package com.xunlei.channel.db.dao;

import org.springframework.dao.DataAccessException;

import com.xunlei.channel.db.pojo.ContactResult;

public interface ContactResultDAO {
    /**
     * 保存到签约表
     * 
     * @param ContactResult
     */
    void saveContactResult(ContactResult contactResult) throws DataAccessException;

    /**
     * 更新签约表
     * 
     * @param payOrder
     */
    void updateContactResult(ContactResult contactResult) throws DataAccessException;

    /**
     * 通过迅雷Id和签约号来查找签约表信息
     * 
     * @param xunleiId和签约号
     * @return ContactResult or null
     */
    ContactResult getContactResultbySignNo(String xunleiId, String signNo)
            throws DataAccessException;

    /**
     * 通过多个条件查询签约|解约结果
     * 
     * @param xunleiId 迅雷ID
     * @param payType 签约的支付类型
     * @param contactType QY or JY
     * @param status S or F
     * @return ContactResult or null
     */
    ContactResult getTheContactResult(String xunleiId, String payType, String contactType,
                                      String status);

    /**
     * 原则上一个用户在一个支付渠道上只有一条签约解约关系
     * 
     * @param xunleiId
     * @param payType
     * @return ContactResult or null
     * @throws DataAccessException
     */
    ContactResult getContactResultByXunleiIdAndPayType(String xunleiId, String payType)
            throws DataAccessException;

}
