package com.xunlei.channel.db.dao;

import org.springframework.dao.DataAccessException;

import com.xunlei.channel.db.pojo.ContactReq;

public interface ContactReqDAO {
    /**
     * 保存到签约表
     * 
     * @param ContactReq
     */
    void saveContactReq(ContactReq contactReq) throws DataAccessException;

    /**
     * 更新签约表
     * 
     * @param payOrder
     */
    void updateContactReq(ContactReq contactReq) throws DataAccessException;

    /**
     * 通过迅雷Id来查找签约表信息
     * 
     * @param xunleiId
     * @return ContactReq or null
     */
    ContactReq getContactReq(String xunleiId) throws DataAccessException;
    
    /**
     * 通过迅雷Id和签约号来查找签约表信息
     * 
     * @param xunleiId
     * @return ContactReq or null
     */
    ContactReq getContactReqbySignNo(String xunleiId,String signNo) throws DataAccessException;

}
