/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.orm.PayOrderMapper;
import com.xunlei.channel.db.pojo.PayOrder;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PayOrderDAOImpl
implements PayOrderDAO {
    private static final Logger logger = LoggerFactory.getLogger(PayOrderDAOImpl.class);
    @Autowired
    private PayOrderMapper payOrderMapper;

    @Override
    @Transactional(readOnly=false)
    public void savePayOrder(PayOrder payOrder) throws DataAccessException {
        Assert.notNull((Object)payOrder);
        logger.info("savePayOrder...xunleiPayId:{}", (Object)payOrder.getXunleiPayId());
        this.payOrderMapper.savePayOrder(payOrder);
    }

    @Override
    public PayOrder getPayOrder(String xunleiPayId) throws DataAccessException {
        Assert.notNull((Object)xunleiPayId);
        return this.payOrderMapper.getPayOrder(xunleiPayId);
    }

    @Override
    public void updateExtraJsonByXunleiPayId(String extraJson, String xunleiPayId) {
        Assert.notNull((Object)xunleiPayId);
        this.payOrderMapper.updateExtraJsonByXunleiPayId(extraJson, xunleiPayId);
    }

    @Override
    @Transactional(readOnly=false)
    public void updateBizExtByXunleiPayId(String bizExt, String xunleiPayId) {
        Assert.notNull((Object)xunleiPayId);
        this.payOrderMapper.updateBizExtByXunleiPayId(bizExt, xunleiPayId);
    }

    @Override
    public PayOrder getPayOrderByBizNoAndBizOrderId(String bizNo, String bizOrderId) throws DataAccessException {
        Assert.notNull((Object)bizNo);
        Assert.notNull((Object)bizOrderId);
        return this.payOrderMapper.getPayOrderByBizNoAndBizOrderId(bizNo, bizOrderId);
    }

    @Override
    public int getCountByBizNoAndBizOrderId(String bizNo, String bizOrderId) throws DataAccessException {
        Assert.notNull((Object)bizOrderId);
        Assert.notNull((Object)bizNo);
        Integer count = this.payOrderMapper.getCountByBizNoAndBizOrderId(bizNo, bizOrderId);
        return count == null ? 0 : count;
    }

    @Override
    @Transactional(readOnly=false)
    public void updatePayOrderStatusAndChannelId(String xunleiPayId, String orderStatus, String channelOrderId) throws DataAccessException {
        Assert.notNull((Object)xunleiPayId);
        Assert.notNull((Object)orderStatus);
        this.payOrderMapper.updatePayOrderStatusAndChannelId(xunleiPayId, orderStatus, channelOrderId);
    }

    @Override
    public void updatePayOrderStatusAndChannelIdAndExtraJson(String xunleiPayId, String orderStatus, String channelOrderId, String extraJson) throws DataAccessException {
        Assert.notNull((Object)xunleiPayId);
        Assert.notNull((Object)orderStatus);
        Assert.notNull((Object)extraJson);
        this.payOrderMapper.updatePayOrderStatusAndChannelIdAndExtraJson(xunleiPayId, orderStatus, channelOrderId, extraJson);
    }

    @Override
    public List<PayOrder> getPayOrderByMinIdAndStatus(long id, String[] status, int limit) throws DataAccessException {
        Assert.notNull((Object)id);
        Assert.notNull((Object)status);
        return this.payOrderMapper.getPayOrderByMinIdAndStatus(id, status, limit);
    }

    @Override
    public List<PayOrder> getPayOrderByCreateTime(String fromTime, String toTime, String[] status, long id, int limit) throws DataAccessException {
        Assert.notNull((Object)fromTime);
        Assert.notNull((Object)toTime);
        return this.payOrderMapper.getPayOrderByCreateTime(fromTime, toTime, status, id, limit);
    }

    @Override
    @Transactional(readOnly=false)
    public void updatePayOrderExtraJsonAndChannelId(String xunleiPayId, String extraJson, String channelOrderId) throws DataAccessException {
        Assert.notNull((Object)xunleiPayId);
        Assert.notNull((Object)extraJson);
        Assert.notNull((Object)channelOrderId);
        this.payOrderMapper.updatePayOrderExtraJsonAndChannelId(xunleiPayId, extraJson, channelOrderId);
    }

    @Override
    public int getCountOfOrderRequestByXunleiIdBizNoAndDate(String xunleiId, String bizNo, Date fromDate, Date toDate) {
        Integer count = this.payOrderMapper.getCountOfOrderRequestByXunleiIdBizNoAndDate(xunleiId, bizNo, fromDate, toDate);
        return count == null ? 0 : count;
    }

    @Override
    public PayOrder getPayOrderByPayTypeAndChannelOrderId(String payType, String channelOrderId) throws DataAccessException {
        Assert.notNull((Object)payType);
        Assert.notNull((Object)channelOrderId);
        return this.payOrderMapper.getPayOrderByPayTypeAndChannelOrderId(payType, channelOrderId);
    }

    @Override
    @Transactional(readOnly=false)
    public void updatePhoneByXunleiPayId(String xunleiPayId, String phone) {
        Assert.notNull((Object)xunleiPayId);
        Assert.notNull((Object)phone);
        this.payOrderMapper.updatePhoneByXunleiPayId(xunleiPayId, phone);
    }
}

