/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.dao.BizDAO;
import com.xunlei.channel.db.orm.BizMapper;
import com.xunlei.channel.db.pojo.Biz;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizDAOImpl
implements BizDAO {
    private static final Logger logger = LoggerFactory.getLogger(BizDAOImpl.class);
    @Autowired
    private BizMapper bizMapper;

    @Override
    public List<Biz> listAllBizs() throws DataAccessException {
        return this.bizMapper.listAllBizs();
    }

    @Override
    @Transactional(readOnly=false)
    public void saveBiz(Biz biz) throws DataAccessException {
        Assert.notNull((Object)biz);
        logger.debug("save biz...bizNo:{},bizName:{}", (Object)biz.getBizNo(), (Object)biz.getBizName());
        this.bizMapper.saveBiz(biz);
    }

    @Override
    public Biz getBiz(String bizNo) throws DataAccessException {
        Assert.notNull((Object)bizNo);
        return this.bizMapper.getBiz(bizNo);
    }
}

