/**
 * Project: dbservice
 * 
 * File Created at 2014年12月29日
 * gonglijian
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.orm;

import java.util.List;

import com.xunlei.channel.db.pojo.CustomOrder;

/**
 * TODO Comment of CustomOrderMapper
 * 
 * @author gonglijian
 */
public interface CustomOrderMapper {

    /**
     * @param customOrder
     */
    void saveCustomOrder(CustomOrder customOrder);

    /**
     * @param xunleiPayId
     * @return
     */
    CustomOrder getCustomOrder(String xunleiPayId);

    /**
     * @param type
     * @param status
     * @return
     */
    List<String> getXunleiPayIdByTypeAndStatus(String type, String status);

    /**
     * 更新status和failMsg字段
     * 
     * @param xunleiPayId
     * @param status
     * @param failMsg
     */
    void updateCustomOrderStatus(String xunleiPayId, String status, String failMsg);

}
