/**
 * Project: dbservice
 * 
 * File Created at 2015年1月26日
 * gonglijian
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xunlei.channel.db.dao.TaskConfigDAO;
import com.xunlei.channel.db.orm.TaskConfigMapper;
import com.xunlei.channel.db.pojo.TaskConfig;

/**
 * TODO Comment of TaskConfigDAOImpl
 * 
 * @author gonglijian
 */
@Service
public class TaskConfigDAOImpl implements TaskConfigDAO {

    private static final Logger logger = LoggerFactory.getLogger(TaskConfigDAOImpl.class);

    @Autowired
    private TaskConfigMapper    taskConfigMapper;

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.task.core.service.TaskService#listAllActiveTaskConfig
     * ()
     */
    @Override
    public List<TaskConfig> listAllActiveTaskConfig() {
        logger.debug("listAllActiveTaskConfig...");
        return this.taskConfigMapper.listAllActiveTaskConfig();
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.task.core.service.TaskConfigService#getTaskConfig(
     * java.lang.String)
     */
    @Override
    public TaskConfig getTaskConfig(String taskNo) {
        return this.taskConfigMapper.getTaskConfig(taskNo);
    }

}
