/**
 * Project: dbservice
 * 
 * File Created at 2014-12-2
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.dao.PayOrderDAO;
import com.xunlei.channel.db.orm.PayOrderMapper;
import com.xunlei.channel.db.pojo.PayOrder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Date;
import java.util.List;

@Service
public class PayOrderDAOImpl implements PayOrderDAO {

    private final static Logger logger = LoggerFactory.getLogger(PayOrderDAOImpl.class);

    @Autowired
    private PayOrderMapper      payOrderMapper;

    @Transactional(readOnly = false)
    @Override
    public void savePayOrder(PayOrder payOrder) throws DataAccessException {
        Assert.notNull(payOrder);
        logger.info("savePayOrder...xunleiPayId:{}", payOrder.getXunleiPayId());
        payOrderMapper.savePayOrder(payOrder);
    }

    @Override
    public PayOrder getPayOrder(String xunleiPayId) throws DataAccessException {
        Assert.notNull(xunleiPayId);
        return payOrderMapper.getPayOrder(xunleiPayId);
    }

    @Override
    public void updateExtraJsonByXunleiPayId(String extraJson, String xunleiPayId) {
        Assert.notNull(xunleiPayId);
        payOrderMapper.updateExtraJsonByXunleiPayId(extraJson, xunleiPayId);
    }

    @Transactional(readOnly = false)
    @Override
    public void updateBizExtByXunleiPayId(String bizExt, String xunleiPayId) {
        Assert.notNull(xunleiPayId);
        payOrderMapper.updateBizExtByXunleiPayId(bizExt, xunleiPayId);
    }

    @Override
    public PayOrder getPayOrderByBizNoAndBizOrderId(String bizNo, String bizOrderId)
            throws DataAccessException {
        Assert.notNull(bizNo);
        Assert.notNull(bizOrderId);
        return payOrderMapper.getPayOrderByBizNoAndBizOrderId(bizNo, bizOrderId);
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.PayOrderDAO#getCountByBizNoAndBizOrderId(java
     * .lang.String, java.lang.String)
     */
    @Override
    public int getCountByBizNoAndBizOrderId(String bizNo, String bizOrderId)
            throws DataAccessException {
        Assert.notNull(bizOrderId);
        Assert.notNull(bizNo);
        Integer count = this.payOrderMapper.getCountByBizNoAndBizOrderId(bizNo, bizOrderId);
        return count == null ? 0 : count;
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.db.dao.PayOrderDAO#updatePayOrderStatusAndChannelId
     * (java.lang.String, java.lang.String)
     */
    @Transactional(readOnly = false)
    @Override
    public void updatePayOrderStatusAndChannelId(String xunleiPayId, String orderStatus,
                                                 String channelOrderId) throws DataAccessException {
        Assert.notNull(xunleiPayId);
        Assert.notNull(orderStatus);
        this.payOrderMapper.updatePayOrderStatusAndChannelId(xunleiPayId, orderStatus,
                channelOrderId);
    }

    @Override
    public void updatePayOrderStatusAndChannelIdAndExtraJson(String xunleiPayId, String orderStatus, String channelOrderId, String extraJson) throws DataAccessException {
        Assert.notNull(xunleiPayId);
        Assert.notNull(orderStatus);
        Assert.notNull(extraJson);
        this.payOrderMapper.updatePayOrderStatusAndChannelIdAndExtraJson(xunleiPayId, orderStatus,
                channelOrderId, extraJson);
    }

    @Override
    public List<PayOrder> getPayOrderByMinIdAndStatus(long id, String[] status, int limit)
            throws DataAccessException {
        Assert.notNull(id);
        Assert.notNull(status);
        return this.payOrderMapper.getPayOrderByMinIdAndStatus(id, status, limit);
    }

    @Override
    public List<PayOrder> getPayOrderByCreateTime(String fromTime, String toTime, String[] status,
                                                  long id, int limit) throws DataAccessException {
        Assert.notNull(fromTime);
        Assert.notNull(toTime);
        return this.payOrderMapper.getPayOrderByCreateTime(fromTime, toTime, status, id, limit);
    }

    @Transactional(readOnly = false)
    @Override
    public void updatePayOrderExtraJsonAndChannelId(String xunleiPayId, String extraJson,
                                                    String channelOrderId)
                                                            throws DataAccessException {
        Assert.notNull(xunleiPayId);
        Assert.notNull(extraJson);
        Assert.notNull(channelOrderId);
        this.payOrderMapper.updatePayOrderExtraJsonAndChannelId(xunleiPayId, extraJson,
                channelOrderId);
    }

    @Override
    public int getCountOfOrderRequestByXunleiIdBizNoAndDate(String xunleiId, String bizNo,
                                                            Date fromDate, Date toDate) {
        Integer count = this.payOrderMapper.getCountOfOrderRequestByXunleiIdBizNoAndDate(xunleiId,
                bizNo, fromDate, toDate);
        return count == null ? 0 : count;
    }

    @Override
    public PayOrder getPayOrderByPayTypeAndChannelOrderId(String payType, String channelOrderId)
            throws DataAccessException {
        Assert.notNull(payType);
        Assert.notNull(channelOrderId);
        return this.payOrderMapper.getPayOrderByPayTypeAndChannelOrderId(payType, channelOrderId);
    }

    @Transactional(readOnly = false)
    @Override
    public void updatePhoneByXunleiPayId(String xunleiPayId, String phone) {
        Assert.notNull(xunleiPayId);
        Assert.notNull(phone);
        this.payOrderMapper.updatePhoneByXunleiPayId(xunleiPayId, phone);
    }
}
