/**
 * Project: dbservice
 * 
 * File Created at 2014-12-2
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.db.dao.BizAutoPayReqDAO;
import com.xunlei.channel.db.orm.BizAutoPayReqMapper;
import com.xunlei.channel.db.pojo.BizAutoPayReq;

@Service
public class BizAutoPayReqDAOImpl implements BizAutoPayReqDAO {

    private final static Logger              logger = LoggerFactory.getLogger(BizAutoPayReqDAOImpl.class);

    @Autowired
    private BizAutoPayReqMapper bizAutoPayReqMapper;

    @Transactional(readOnly = false)
    @Override
    public void saveBizAutoPayReq(BizAutoPayReq bizAutoPayReq) throws DataAccessException {
        bizAutoPayReqMapper.saveBizAutoPayReq(bizAutoPayReq);
    }

    @Override
    public BizAutoPayReq getBizAutoPayReq(String xunleiId) throws DataAccessException {
        Assert.notNull(xunleiId);
        return bizAutoPayReqMapper.getBizAutoPayReq(xunleiId);
    }

    @Transactional(readOnly = false)
    @Override
    public void updateBizAutoPayReq(BizAutoPayReq bizAutoPayReq) throws DataAccessException {
        Assert.notNull(bizAutoPayReq);
        logger.debug("updateBizAutoPayReq...xunleiPayId:{}", bizAutoPayReq.getXunleiId());
        bizAutoPayReqMapper.updateBizAutoPayReq(bizAutoPayReq);
    }

}
