/**
 * Project: dbservice
 * 
 * File Created at 2015年3月12日
 * lizhaog
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao;

import com.xunlei.channel.db.pojo.RiskControlTask;
import org.springframework.dao.DataAccessException;

import java.util.List;

/**
 * @author lizhaog
 */
public interface RiskControlTaskDAO {

    public RiskControlTask getRiskControlTaskByName(String taskName) throws DataAccessException;

    public List<String> getAllTaskName() throws DataAccessException;

    /**
     * 根据非空属性，查找符合条件的值的数量
     * 
     * @param taskName
     * @param inUse
     * @param fromTime 以create_time为筛选
     * @param toTime 以create_time为筛选
     * @return
     * @throws DataAccessException
     */
    public int getRiskControlTaskCount(String taskName, String inUse, String fromTime, String toTime)
            throws DataAccessException;

    /**
     * 根据非空属性，查找符合条件的值
     * orderBy 能造成sql注入，目前该方法仅限用于渠道后台
     * 
     * @param taskName
     * @param inUse
     * @param fromTime 以create_time为筛选
     * @param toTime 以create_time为筛选
     * @param orderBy
     * @param limit
     * @return
     */
    public List<RiskControlTask> getRiskControlTaskList(String taskName, String inUse,
                                                        String fromTime, String toTime,
                                                        String orderBy, String limit)
            throws DataAccessException;

    public void saveRiskControlTask(RiskControlTask riskControlTask) throws DataAccessException;

    /**
     * 根据taskName更新所有属性值
     * 
     * @param riskControlTask
     * @throws DataAccessException
     */
    public void updateRiskControlTask(RiskControlTask riskControlTask) throws DataAccessException;

}
