/**
 * Project: dbservice
 * 
 * File Created at 2015年1月12日
 * gonglijian
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.pojo;

import java.util.Date;

/**
 * 任务执行完成后的统计信息
 * 
 * @author gonglijian
 */
public class TaskResult {
    public static final String RESULT_OK   = "ok";
    public static final String RESULT_FAIL = "fail";
    private Long               id;
    private String             taskNo;
    private String             result;              //ok|error
    private long               heapMemory;          //堆内存大小
    private long               nonHeapMemory;       //非堆内存大小
    private long               cpuTime;             // 单位 ms 
    private Date               startTime;
    private Date               endTime;
    private String             remark;
    private String             balanceDate;

    /**
     * @return the balanceDate
     */
    public String getBalanceDate() {
        return balanceDate;
    }

    /**
     * @param balanceDate the balanceDate to set
     */
    public void setBalanceDate(String balanceDate) {
        this.balanceDate = balanceDate;
    }

    /**
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the taskNo
     */
    public String getTaskNo() {
        return taskNo;
    }

    /**
     * @param taskNo the taskNo to set
     */
    public void setTaskNo(String taskNo) {
        this.taskNo = taskNo;
    }

    /**
     * @return the result
     */
    public String getResult() {
        return result;
    }

    /**
     * @param result the result to set
     */
    public void setResult(String result) {
        this.result = result;
    }

    /**
     * @return the heapMemory
     */
    public long getHeapMemory() {
        return heapMemory;
    }

    /**
     * @param heapMemory the heapMemory to set
     */
    public void setHeapMemory(long heapMemory) {
        this.heapMemory = heapMemory;
    }

    /**
     * @return the nonHeapMemory
     */
    public long getNonHeapMemory() {
        return nonHeapMemory;
    }

    /**
     * @param nonHeapMemory the nonHeapMemory to set
     */
    public void setNonHeapMemory(long nonHeapMemory) {
        this.nonHeapMemory = nonHeapMemory;
    }

    /**
     * @return the cpuTime
     */
    public long getCpuTime() {
        return cpuTime;
    }

    /**
     * @param cpuTime the cpuTime to set
     */
    public void setCpuTime(long cpuTime) {
        this.cpuTime = cpuTime;
    }

    /**
     * @return the startTime
     */
    public Date getStartTime() {
        return startTime;
    }

    /**
     * @param startTime the startTime to set
     */
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    /**
     * @return the endTime
     */
    public Date getEndTime() {
        return endTime;
    }

    /**
     * @param endTime the endTime to set
     */
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    /**
     * @return the remark
     */
    public String getRemark() {
        return remark;
    }

    /**
     * @param remark the remark to set
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * @return
     */
    public boolean isOk() {
        return RESULT_OK.equals(this.result);
    }

}
