/**
 * Project: dbservice
 * 
 * File Created at 2015年3月12日
 * lizhaog
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.orm;

import java.util.List;

import org.springframework.dao.DataAccessException;

import com.xunlei.channel.db.pojo.RiskControlTask;

/**
 * @author lizhaog
 */
public interface RiskControlTaskMapper {

    public RiskControlTask getRiskControlTaskByName(String taskName) throws DataAccessException;

    public List<String> getAllTaskName() throws DataAccessException;

    public int getRiskControlTaskCount(String taskName, String inUse, String fromTime,
                                       String toTime) throws DataAccessException;

    public List<RiskControlTask> getRiskControlTaskList(String taskName, String inUse,
                                                        String fromTime, String toTime,
                                                        String orderBy, String limit)
                                                                throws DataAccessException;

    public void saveRiskControlTask(RiskControlTask riskControlTask) throws DataAccessException;

    public void updateRiskControlTask(RiskControlTask riskControlTask) throws DataAccessException;
}
