/**
 * 
 */
package com.xunlei.channel.db.orm;

import java.util.Date;
import java.util.List;

import org.springframework.dao.DataAccessException;

import com.xunlei.channel.db.pojo.PayOrder;

/**
 * @author gonglijian
 */
public interface PayOrderMapper {

    /**
     * 保存到请求表
     * 
     * @param payOrder
     */
    void savePayOrder(PayOrder payOrder);

    /**
     * 保存到请求表
     * 
     * @param payOrder
     */
    void updatePayOrder(PayOrder payOrder);

    /**
     * 通过迅雷支付号来查找请求订单信息
     * 
     * @param xunleiPayId
     * @return PayOrder or null
     */
    PayOrder getPayOrder(String xunleiPayId);

    /**
     * @param bizNo
     * @param bizOrderId
     * @return
     */
    PayOrder getPayOrderByBizNoAndBizOrderId(String bizNo, String bizOrderId);

    /**
     * 根据业务方唯一订单号获取订单
     * 
     * @param bizOrderId 业务方未已订单号
     * @return
     * @throws DataAccessException
     */
    PayOrder getPayOrderByBizOrderId(String bizOrderId);

    /**
     * @param bizNo
     * @param bizOrderId
     * @return
     */
    Integer getCountByBizNoAndBizOrderId(String bizNo, String bizOrderId);

    /**
     * @param xunleiPayId
     * @param orderStatus
     * @param channelOrderId
     */
    void updatePayOrderStatusAndChannelId(String xunleiPayId, String orderStatus,
                                          String channelOrderId);

    /**
     * @param bizOrderId
     * @throws DataAccessException
     */
    void deletePayOrder(String bizOrderId) throws DataAccessException;

    /**
     * 获取大于id且订单状态为orderStatus数组中状态的所有订单信息
     * 
     * @param id
     * @param status
     * @return
     * @throws DataAccessException
     */
    List<PayOrder> getPayOrderByMinIdAndStatus(long id, String[] status, int limit)
            throws DataAccessException;

    /**
     * 获取createTime在fromTime到toTime之间的订单信息
     * 
     * @param fromTime
     * @param toTime
     * @return
     * @throws DataAccessException
     */
    List<PayOrder> getPayOrderByCreateTime(String fromTime, String toTime, String[] status, long id,
                                           int limit) throws DataAccessException;

    /**
     * 获取用户一定日期内的订单请求总数(请求表记录总数)
     * 
     * @param xunleiId 迅雷Id
     * @param bizNo 业务编号
     * @param fromDate 开始日期
     * @param toDate 结束日期
     * @return
     */
    Integer getCountOfOrderRequestByXunleiIdBizNoAndDate(String xunleiId, String bizNo,
                                                         Date fromDate, Date toDate);

    /**
     * 获取用户一定日期内的订单请求总数(请求表记录总数)
     * 
     * @param phone 电话号码
     * @param fromDate 开始日期
     * @param toDate 结束日期
     * @return
     */
    Integer getCountOfOrderRequestByphoneAndDate(String phone, Date fromDate, Date toDate);

    /**
     * 查找订单，查询条件为非空的参数(version、page_charset、notify_url、page_url除外)
     * 
     * @param payOrder
     * @return
     */
    PayOrder findPayOrder(PayOrder payOrder);

    /**
     * 更新订单的json扩展参数
     * 
     * @param extraJson
     * @param xunleiPayId
     */
    void updateExtraJsonByXunleiPayId(String extraJson, String xunleiPayId);

    /**
     * 更新订单的bizExt
     * 
     * @param bizExt 扩展参数
     * @param xunleiPayId
     */
    void updateBizExtByXunleiPayId(String bizExt, String xunleiPayId);

    /**
     * 更新请求订单的extra字段和渠道支付号
     * 
     * @param xunleiPayId
     * @param channelOrderId
     * @param extraJson
     */
    void updatePayOrderExtraJsonAndChannelId(String xunleiPayId, String extraJson,
                                             String channelOrderId) throws DataAccessException;

    /**
     * 通过第三方支付订单号获取订单
     * 
     * @param payType
     * @param channelOrderId
     * @return PayOrder or null
     * @throws DataAccessException
     */
    PayOrder getPayOrderByPayTypeAndChannelOrderId(String payType, String channelOrderId)
            throws DataAccessException;

}
