/**
 * 
 */
package com.xunlei.channel.db.orm;

import java.util.List;

import com.xunlei.channel.db.pojo.ContactReq;


/**
 * @author lishaojun
 */
public interface ContactReqMapper {

    /**
     * 保存到签约表
     * 
     * @param ContactReq
     */
    void saveContactReq(ContactReq contactReq);
    
    /**
     * 更新签约表
     * 
     * @param ContactReq
     */
    void updateContactReq(ContactReq contactReq);
    
    /**
     * 通过迅雷Id来查找签约表信息
     * 
     * @param xunleiId
     * @return ContactReq or null
     */
    ContactReq getContactReq(String xunleiId);
    
    /**
     * 通过迅雷Id和签约号来查找签约表信息
     * 
     * @param xunleiId
     * @return ContactReq or null
     */
    ContactReq getContactReqbySignNo(String xunleiId,String signNo);

    
    /**
     * 查询所有的签约表信息
     * @return List
     */
    List<ContactReq> listAllContactReq();

}
