/**
 * Project: dbservice
 * 
 * File Created at 2015年1月26日
 * gonglijian
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.xunlei.channel.db.dao.TaskStatisticDAO;
import com.xunlei.channel.db.orm.TaskStatisticMapper;
import com.xunlei.channel.db.pojo.TaskStatistic;

/**
 * TODO Comment of TaskStatisticDAOImpl
 * 
 * @author gonglijian
 */
@Service
public class TaskStatisticDAOImpl implements TaskStatisticDAO {
    private static final Logger logger = LoggerFactory.getLogger(TaskStatisticDAOImpl.class);

    @Autowired
    private TaskStatisticMapper taskStatisticMapper;

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.task.core.service.TaskStatisticService#increaseOkStatistic
     * (java.lang.String, java.lang.String)
     */
    @Override
    public void increaseStatistic(String taskNo, String balanceDate, boolean isOk) {
        logger.info("increaseStatistic...taskNo:{},balanceDate:{},isOk:{}", taskNo, balanceDate,
                isOk);
        TaskStatistic statistic = getTaskStatistic(taskNo, balanceDate);
        if (null == statistic) {
            statistic = new TaskStatistic();
            statistic.setBalanceDate(balanceDate);
            statistic.setTaskNo(taskNo);
        }

        if (isOk) {
            statistic.increaseSuccessCount();
        } else {
            statistic.increaseFailCount();
        }

        if (null == statistic.getId()) {//new
            this.saveTaskStatistic(statistic);
        } else {//update
            this.updateTaskStatistic(statistic);
        }
    }

    /**
     * @param statistic
     */
    @Transactional(readOnly = false)
    private void updateTaskStatistic(TaskStatistic statistic) {
        this.taskStatisticMapper.updateTaskStatistic(statistic);
    }

    /**
     * @param statistic
     */
    @Transactional(readOnly = false)
    private void saveTaskStatistic(TaskStatistic statistic) {
        this.taskStatisticMapper.saveTaskStatistic(statistic);
    }

    /**
     * @param taskNo
     * @param balanceDate
     * @return
     */
    private TaskStatistic getTaskStatistic(String taskNo, String balanceDate) {
        return this.taskStatisticMapper.getTaskStatistic(taskNo, balanceDate);
    }

    /*
     * (non-Javadoc)
     * @see
     * com.xunlei.channel.task.core.service.TaskStatisticService#listTaskStatistic
     * (java.lang.String, java.lang.String)
     */
    @Override
    public List<TaskStatistic> listTaskStatistic(String startDate, String endDate) {
        return this.taskStatisticMapper.listTaskStatistic(startDate, endDate);
    }

}
