/**
 * Project: dbservice
 * File Created at 2014-12-1
 * laiquan.luolq
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao;

import java.util.Date;
import java.util.List;

import org.springframework.dao.DataAccessException;

import com.xunlei.channel.db.pojo.PayOrder;

/**
 * 操作订单表的方法，注意：订单表不移表，里面包含成功订单和失败订单
 *
 * @author laiquan.luolq
 */
public interface PayOrderDAO {

    /**
     * 保存请求订单信息到数据库
     *
     * @param payOrder
     * @throws DataAccessException
     */
    public void savePayOrder(PayOrder payOrder) throws DataAccessException;

    /**
     * 通过xunleiPayId获得请求订单的实体
     *
     * @param xunleiPayId
     * @return PayOrder
     * @throws DataAccessException
     */
    public PayOrder getPayOrder(String xunleiPayId) throws DataAccessException;

    /**
     * 更新订单的json扩展参数
     * 
     * @param extraJson
     * @param xunleiPayId
     */
    public void updateExtraJsonByXunleiPayId(String extraJson, String xunleiPayId);

    /**
     * 更新订单的bizExt
     * 
     * @param bizExt 扩展参数
     * @param xunleiPayId
     */
    public void updateBizExtByXunleiPayId(String bizExt, String xunleiPayId);

    /**
     * @param bizNo
     * @param bizOrderId
     * @return
     */
    public PayOrder getPayOrderByBizNoAndBizOrderId(String bizNo, String bizOrderId)
            throws DataAccessException;

    /**
     * @param bizNo
     * @param bizOrderId
     * @return
     */
    public int getCountByBizNoAndBizOrderId(String bizNo, String bizOrderId)
            throws DataAccessException;

    /**
     * 更新请求订单的支付状态和渠道支付号
     *
     * @param xunleiPayId
     * @param channelOrderId
     * @param orderStatus
     */
    public void updatePayOrderStatusAndChannelId(String xunleiPayId, String orderStatus,
                                                 String channelOrderId) throws DataAccessException;

    /**
     * 获取大于id且订单状态为orderStatus数组中状态的所有订单信息 使用id升序排列
     *
     * @param id
     * @param orderStatus
     * @return
     * @throws DataAccessException
     */
    public List<PayOrder> getPayOrderByMinIdAndStatus(long id, String[] status, int limit)
            throws DataAccessException;

    /**
     * 获取createTime在fromTime到toTime之间且大于id的订单信息 按id升序排列
     *
     * @param fromTime
     * @param toTime
     * @return
     * @throws DataAccessException
     */
    public List<PayOrder> getPayOrderByCreateTime(String fromTime, String toTime, String[] status,
                                                  long id, int limit) throws DataAccessException;

    /**
     * 获取用户一定日期内的订单请求总数(请求表记录总数)
     *
     * @param xunleiId 迅雷Id
     * @param bizNo 业务编号
     * @param fromDate 开始日期
     * @param toDate 结束日期
     * @return
     */
    public int getCountOfOrderRequestByXunleiIdBizNoAndDate(String xunleiId, String bizNo,
                                                            Date fromDate, Date toDate);

    /**
     * 更新请求订单的extra字段和渠道支付号
     * 
     * @param xunleiPayId
     * @param channelOrderId
     * @param extraJson
     */
    void updatePayOrderExtraJsonAndChannelId(String xunleiPayId, String extraJson,
                                             String channelOrderId) throws DataAccessException;

    /**
     * 通过第三方支付订单号获取订单
     * 
     * @param payType 支付类型
     * @param channelOrderId 渠道订单号
     * @return PayOrder or null
     * @throws DataAccessException
     */
    public PayOrder getPayOrderByPayTypeAndChannelOrderId(String payType, String channelOrderId)
            throws DataAccessException;

}
