/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.dao.CustomOrderDAO;
import com.xunlei.channel.db.orm.CustomOrderMapper;
import com.xunlei.channel.db.pojo.CustomOrder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomOrderDAOImpl
implements CustomOrderDAO {
    private static final Logger logger = LoggerFactory.getLogger(CustomOrderDAOImpl.class);
    @Autowired
    private CustomOrderMapper customOrderMapper;

    @Override
    public CustomOrder getCustomOrder(String xunleiPayId) {
        logger.debug("getCustomOrder...xunleiPayId:{}", (Object)xunleiPayId);
        if (null == xunleiPayId) {
            return null;
        }
        return this.customOrderMapper.getCustomOrder(xunleiPayId);
    }

    @Override
    @Transactional(readOnly=false)
    public void saveCustomOrder(CustomOrder customOrder) {
        this.customOrderMapper.saveCustomOrder(customOrder);
    }

    @Override
    public List<String> listWaitedXunleiPayId() {
        return this.customOrderMapper.getXunleiPayIdByTypeAndStatus("R", "W");
    }

    @Override
    @Transactional(readOnly=false)
    public void customOrderSuccess(String xunleiPayId) {
        logger.info("customOrderSuccess...xunleiPayId:{}", (Object)xunleiPayId);
        this.customOrderMapper.updateCustomOrderStatus(xunleiPayId, "S", "SUCCESS");
    }

    @Override
    @Transactional(readOnly=false)
    public void customOrderfailed(String xunleiPayId, String failMsg) {
        logger.info("customOrderfailed...xunleiPayId:{},failMsg:{}", (Object)xunleiPayId, (Object)failMsg);
        this.customOrderMapper.updateCustomOrderStatus(xunleiPayId, "F", failMsg);
    }
}

