/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.dao.ContactResultDAO;
import com.xunlei.channel.db.orm.ContactResultMapper;
import com.xunlei.channel.db.pojo.ContactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ContactResultDAOImpl
implements ContactResultDAO {
    private static final Logger logger = LoggerFactory.getLogger(ContactResultDAOImpl.class);
    @Autowired
    private ContactResultMapper ContactResultMapper;

    @Override
    @Transactional(readOnly=false)
    public void saveContactResult(ContactResult contactResult) throws DataAccessException {
        this.ContactResultMapper.saveContactResult(contactResult);
    }

    @Override
    @Transactional(readOnly=false)
    public void updateContactResult(ContactResult contactResult) throws DataAccessException {
        Assert.notNull((Object)contactResult);
        logger.debug("updateContactResult...xunleiPayId:{}", (Object)contactResult.getXunleiId());
        this.ContactResultMapper.updateContactResult(contactResult);
    }

    @Override
    public ContactResult getContactResultbySignNo(String xunleiId, String signNo) throws DataAccessException {
        Assert.notNull((Object)xunleiId);
        Assert.notNull((Object)signNo);
        return this.ContactResultMapper.getContactResultbySignNo(xunleiId, signNo);
    }

    @Override
    public ContactResult getTheContactResult(String xunleiId, String payType, String contactType, String status) {
        Assert.notNull((Object)xunleiId);
        Assert.notNull((Object)payType);
        Assert.notNull((Object)contactType);
        Assert.notNull((Object)status);
        return this.ContactResultMapper.getTheContactResult(xunleiId, payType, contactType, status);
    }

    @Override
    public ContactResult getContactResultByXunleiIdAndPayType(String xunleiId, String payType) throws DataAccessException {
        Assert.notNull((Object)xunleiId);
        Assert.notNull((Object)payType);
        return this.ContactResultMapper.getContactResultByXunleiIdAndPayType(xunleiId, payType);
    }
}

