/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.dao.ContactReqDAO;
import com.xunlei.channel.db.orm.ContactReqMapper;
import com.xunlei.channel.db.pojo.ContactReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ContactReqDAOImpl
implements ContactReqDAO {
    private static final Logger logger = LoggerFactory.getLogger(ContactReqDAOImpl.class);
    @Autowired
    private ContactReqMapper ContactReqMapper;

    @Override
    @Transactional(readOnly=false)
    public void saveContactReq(ContactReq contactReq) throws DataAccessException {
        this.ContactReqMapper.saveContactReq(contactReq);
    }

    @Override
    public ContactReq getContactReq(String xunleiId) throws DataAccessException {
        Assert.notNull((Object)xunleiId);
        return this.ContactReqMapper.getContactReq(xunleiId);
    }

    @Override
    @Transactional(readOnly=false)
    public void updateContactReq(ContactReq contactReq) throws DataAccessException {
        Assert.notNull((Object)contactReq);
        logger.debug("save payOrder...xunleiPayId:{}", (Object)contactReq.getXunleiId());
        this.ContactReqMapper.updateContactReq(contactReq);
    }

    @Override
    public ContactReq getContactReqbySignNo(String xunleiId, String signNo) throws DataAccessException {
        Assert.notNull((Object)xunleiId);
        Assert.notNull((Object)signNo);
        return this.ContactReqMapper.getContactReqbySignNo(xunleiId, signNo);
    }
}

