/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.dao.TaskResultDAO;
import com.xunlei.channel.db.dao.TaskStatisticDAO;
import com.xunlei.channel.db.orm.TaskResultMapper;
import com.xunlei.channel.db.pojo.TaskResult;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskResultDAOImpl
implements TaskResultDAO {
    private static final Logger logger = LoggerFactory.getLogger(TaskResultDAOImpl.class);
    @Autowired
    private TaskResultMapper taskResultMapper;
    @Autowired
    private TaskStatisticDAO taskStatisticDAO;

    @Override
    @Transactional(readOnly=false)
    public void saveTaskResult(TaskResult taskResult) {
        this.taskResultMapper.saveTaskResult(taskResult);
        this.taskStatisticDAO.increaseStatistic(taskResult.getTaskNo(), taskResult.getBalanceDate(), taskResult.isOk());
    }

    @Override
    public void saveFailResult(String taskNo, String errorMsg) {
        logger.info("saveFailResult...taskNo:{},errorMsg:{}", (Object)taskNo, (Object)errorMsg);
        Calendar ca = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        TaskResult result = new TaskResult();
        result.setBalanceDate(format.format(ca.getTime()));
        result.setCpuTime(0L);
        result.setEndTime(ca.getTime());
        result.setHeapMemory(0L);
        result.setNonHeapMemory(0L);
        result.setRemark(errorMsg);
        result.setResult("fail");
        result.setStartTime(ca.getTime());
        result.setTaskNo(taskNo);
        this.saveTaskResult(result);
    }
}

