/**
 * Project: dbservice
 * 
 * File Created at 2015年3月12日
 * lizhaog
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.orm;

import java.util.List;

import org.springframework.dao.DataAccessException;

import com.xunlei.channel.db.pojo.RiskControlResult;

/**
 * @author lizhaog
 */
public interface RiskControlResultMapper {

    public void saveRiskControlResult(RiskControlResult riskControlResult)
            throws DataAccessException;

    public RiskControlResult getRiskControlResult(String dataId, String taskName)
            throws DataAccessException;

    public RiskControlResult getRiskControlResultById(long id) throws DataAccessException;

    public void updateRiskControlResult(RiskControlResult riskControlResult)
            throws DataAccessException;

    public List<RiskControlResult> getRiskControlResultByValueAndAlarmLevel(String resusltValue,
                                                                            String[] alarmLevel,
                                                                            int limit)
                                                                                    throws DataAccessException;

    public int getRiskControlResultCount(String taskName, String resultValue, String dataId,
                                         String alarmLevel, String fromTime, String toTime)
                                                 throws DataAccessException;

    public List<RiskControlResult> getRiskControlResultList(String taskName, String resultValue,
                                                            String dataId, String alarmLevel,
                                                            String fromTime, String toTime,
                                                            String orderBy, String limit)
                                                                    throws DataAccessException;
}
