package com.xunlei.channel.db.dao.impl;

import com.xunlei.channel.db.dao.ConfigInfoDAO;
import com.xunlei.channel.db.orm.ConfigInfoMapper;
import com.xunlei.channel.db.pojo.ConfigInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

@Service
public class ConfigInfoDAOImpl implements ConfigInfoDAO {

    private final static Logger logger = LoggerFactory.getLogger(ConfigInfoDAOImpl.class);

    @Autowired
    private ConfigInfoMapper    configInfoMapper;

    @Transactional(readOnly = false)
    @Override
    public void saveConfigInfo(ConfigInfo configInfo) throws DataAccessException {
        configInfoMapper.saveConfigInfo(configInfo);
    }

    @Transactional(readOnly = false)
    @Override
    public void updateConfigInfo(ConfigInfo configInfo) throws DataAccessException {
        configInfoMapper.updateConfigInfo(configInfo);
    }

    @Override
    public List<ConfigInfo> getConfigInfo(ConfigInfo configInfo) throws DataAccessException {
        Assert.notNull(configInfo);
        return configInfoMapper.getConfigInfo(configInfo);
    }

    @Transactional(readOnly = false)
    @Override
    public void deleteConfigInfo(ConfigInfo configInfo) throws DataAccessException {
        Assert.notNull(configInfo);
        logger.debug("deleteConfigInfo");
        this.configInfoMapper.deleteConfigInfo(configInfo);
    }

}
