/**
 * Project: dbservice
 * 
 * File Created at 2015年3月12日
 * lizhaog
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.dao;

import com.xunlei.channel.db.pojo.RiskControlResult;
import org.springframework.dao.DataAccessException;

import java.util.List;

/**
 * @author lizhaog
 */
public interface RiskControlResultDAO {

    public void saveRiskControlResult(RiskControlResult riskControlResult)
            throws DataAccessException;

    /**
     * 根据taskName和dataId来获取唯一决定的记录
     * 
     * @param dataId
     * @param taskName
     * @return
     * @throws DataAccessException
     */
    public RiskControlResult getRiskControlResult(String dataId, String taskName)
            throws DataAccessException;
    
    public RiskControlResult getRiskControlResultById(long id)
            throws DataAccessException;

    /**
     * @param resusltValue
     * @param alarmLevel
     * @param limit
     * @return
     * @throws DataAccessException
     */
    public List<RiskControlResult> getRiskControlResultByValueAndAlarmLevel(String resusltValue,
                                                                            String[] alarmLevel,
                                                                            int limit)
            throws DataAccessException;

    /**
     * 将 riskControlResult.dataId 和 riskControlResult.taskName
     * 对应的行，更新为riskControlResult的值；
     * 注意，如果riskControlResult有空值，也会被更新
     * 
     * @param riskControlResult
     * @throws DataAccessException
     */
    public void updateRiskControlResult(RiskControlResult riskControlResult)
            throws DataAccessException;

    /**
     * 根据非空属性，查找符合条件的值的数量
     * 
     * @param taskName
     * @param resultValue
     * @param dataId
     * @param alarmLevel
     * @param fromTime 以create_time为筛选
     * @param toTime 以create_time为筛选
     * @return
     * @throws DataAccessException
     */
    public int getRiskControlResultCount(String taskName, String resultValue, String dataId,
                                         String alarmLevel, String fromTime, String toTime);

    /**
     * 根据非空属性，查找符合条件的值
     * orderBy 能造成sql注入，目前该方法仅限用于渠道后台
     * 
     * @param taskName
     * @param resultValue
     * @param dataId
     * @param alarmLevel
     * @param fromTime 以create_time为筛选
     * @param toTime 以create_time为筛选
     * @param orderBy
     * @param limit
     * @return
     */
    public List<RiskControlResult> getRiskControlResultList(String taskName, String resultValue,
                                                            String dataId, String alarmLevel,
                                                            String fromTime, String toTime,
                                                            String orderBy, String limit);

}
