/**
 * 
 */
package com.xunlei.channel.db.dao;

import java.util.List;

import org.springframework.dao.DataAccessException;

import com.xunlei.channel.db.pojo.Biz;

/**
 * 
 */
public interface BizDAO {

    /**
     * 得到所有的业务方信息
     * 
     * @return
     * @throws DataAccessException
     */
    List<Biz> listAllBizs() throws DataAccessException;

    /**
     * 保持业务方信息到数据库
     * 
     * @param biz
     * @throws DataAccessException
     */
    void saveBiz(Biz biz) throws DataAccessException;

    /**
     * 通过bizNo得到唯一的一个业务方信息
     * 
     * @param bizNo 唯一业务号
     * @return Biz
     * @throws DataAccessException
     */
    Biz getBiz(String bizNo) throws DataAccessException;
}
