/**
 * 
 */
package com.xunlei.channel.db.orm;

import java.util.Date;
import java.util.List;

import com.xunlei.channel.db.pojo.PayOrderOk;

/**
 * @author gonglijian
 */
public interface PayOrderOkMapper {

    /**
     * 保持成功订单信息到订单成功表
     * 
     * @param payOrderOk
     */
    void savePayOrderOk(PayOrderOk payOrderOk);
    
    /**
     * 保存到成功
     * 
     * @param payOrderOk
     */
    void updatePayOrderOk(PayOrderOk payOrderOk);

    /**
     * 得到成功订单的所有信息
     * 
     * @param xunleiPayId
     * @return PayOrderOk or null
     */
    PayOrderOk getPayOrderOk(String xunleiPayId);
    
    /**
     * @param bizNo
     * @param bizOrderId
     * @return
     */
    PayOrderOk getPayOrderOkByBizNoAndBizOrderId(String bizNo, String bizOrderId);

    /**
     * 得到成功订单的通知状态信息
     * 
     * @param xunleiPayId
     * @return noticeStatus of the PayOrderOk
     */
    String getPayOrderOkSendNoticeStatus(String xunleiPayId);

    /**
     * @param xunleiPayId
     * @param sendNoticeStatus
     */
    void updateSendNoticeStatus(String xunleiPayId, String sendNoticeStatus);

    /**
     * 
     * @param sendNoticeStatus 
     * @param fromTime
     * @param endTime
     * @return
     */
	List<String> listUnsuccessNoticeXunleiPayId(String sendNoticeStatus, Date fromTime, Date endTime);
}
