/**
 * Project: dbservice
 * 
 * File Created at 2014年12月11日
 * gonglijian
 * 
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.db.orm;

import java.util.Date;
import java.util.List;
import com.xunlei.channel.db.pojo.PayNoticeFail;

/**
 * TODO Comment of PayNoticeFailMapper
 * 
 * @author gonglijian
 */
public interface PayNoticeFailMapper {

    /**
     * @param xunleiPayId
     * @return
     */
    PayNoticeFail getPayNoticeFail(String xunleiPayId);

    /**
     * @param payNoticeFail
     */
    void savePayNoticeFail(PayNoticeFail payNoticeFail);

    /**
     * @param payNoticeFail
     */
    void updatePayNoticeFail(PayNoticeFail payNoticeFail);

    /**
     * 查询所有的失败通知表的信息
     * 
     * @return List
     */
    List<PayNoticeFail> listAllPayNoticeFail();

    /**
     * 得到满足查询条件的通知失败数据
     * 
     * @param noticeTime 上次失败的通知时间
     * @param minFailTimes 最少失败次数
     * @param maxFailTimes 最多失败次数
     * @return 失败通知集合
     */
    List<PayNoticeFail> getPayNoticeFailList(Date noticeTime, int minFailTimes, int maxFailTimes);

}
